/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.variables.management.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.variables.management.rest.v1.dto.StringResponse;
import org.qubership.integration.platform.variables.management.service.SecuredVariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/secured-variables"})
@CrossOrigin(origins={"*"})
@Tag(name="secured-variable-controller", description="Secured Variable Controller")
public class SecuredVariableController {
    private static final Logger log = LoggerFactory.getLogger(SecuredVariableController.class);
    private final SecuredVariableService securedVariableService;

    @Autowired
    public SecuredVariableController(SecuredVariableService securedVariableService) {
        this.securedVariableService = securedVariableService;
    }

    @Operation(description="Get all secured variables names")
    @GetMapping
    public ResponseEntity<Set<String>> getVariables() {
        if (log.isDebugEnabled()) {
            log.debug("Request to get secured variables");
        }
        return ResponseEntity.ok(this.securedVariableService.getVariablesForDefaultSecret(true));
    }

    @Operation(description="Add new secured variable(s)")
    @PostMapping
    public ResponseEntity<Set<String>> addVariables(@RequestBody @Parameter(description="Variables map of <key, value> to add") Map<String, String> variables) {
        log.info("Request to add secured variables");
        Set<String> addedVariables = this.securedVariableService.addVariablesToDefaultSecret(variables);
        return ResponseEntity.ok(addedVariables);
    }

    @Operation(description="Update or add single secured variable")
    @PatchMapping(value={"/{securedVariableName}"})
    public ResponseEntity<StringResponse> updateVariable(@PathVariable @Parameter(description="Secured variable name") String securedVariableName, @RequestBody(required=false) @Parameter(description="Secured variable value") String value) {
        log.info("Request to update secured variable {}", (Object)securedVariableName);
        String updatedVariable = this.securedVariableService.updateVariableInDefaultSecret(securedVariableName, value);
        return ResponseEntity.ok((Object)new StringResponse(updatedVariable));
    }

    @Operation(description="Delete set of secured variables")
    @DeleteMapping
    public ResponseEntity<Void> deleteVariables(@RequestParam @Parameter(description="Set of names of secured variables") Set<String> variablesNames) {
        log.info("Request to delete secured variables");
        this.securedVariableService.deleteVariablesFromDefaultSecret(variablesNames);
        return ResponseEntity.noContent().build();
    }

    @Operation(description="Import secured variables from a file")
    @PostMapping(value={"/import"})
    public ResponseEntity<Set<String>> importVariables(@RequestParam(value="file") @Parameter(description="File to import") MultipartFile file) {
        log.info("Request to import secured variables");
        Set<String> result = this.securedVariableService.importVariablesRequest(file);
        return result.isEmpty() ? ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build() : ResponseEntity.ok().body(result);
    }
}

