/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.ExecVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="exec")
@Summary(value="Execute inventory-tool")
public class ExecCommand
extends AbstractCommand {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExecCommand.class);
    public static final String DEFAULT_INPUT_DIRECTORY_DOCKER = "/var/input";
    public static final String DEFAULT_OUTPUT_DIRECTORY_DOCKER = "/var/output";

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void run() throws CLIException {
        this.getLogger().info("Inventory tool main flow execution");
        this.runFlow(new ExecVerticle(), null);
    }

    protected void logAndFillDirs() {
        boolean isDocker = Boolean.parseBoolean(this.properties.getOrDefault("dockerMode", "false"));
        this.getLogger().info("dockerMode: {}", (Object)isDocker);
        String defInputDirectory = this.getDefaultInputDir(isDocker);
        String defOutputDirectory = this.getDefaultOutputDir(isDocker);
        this.getLogger().info("explicit inputDirectory: {}", this.properties.get("ciInputDirectory"));
        this.getLogger().info("default inputDirectory: {}", (Object)defInputDirectory);
        this.getLogger().info("explicit outputDirectory: {}", this.properties.get("ciOutputDirectory"));
        this.getLogger().info("default outputDirectory: {}", (Object)defOutputDirectory);
        if (!this.properties.containsKey("ciInputDirectory")) {
            if (defInputDirectory != null) {
                this.properties.put("ciInputDirectory", DEFAULT_INPUT_DIRECTORY_DOCKER);
            } else {
                LOGGER.error("Either --docker=true or --inputDirectory must be specified! EXITTING!");
                System.exit(1);
            }
        }
        if (!this.properties.containsKey("ciOutputDirectory") && defOutputDirectory != null) {
            this.properties.put("ciOutputDirectory", defOutputDirectory);
        }
    }

    protected String getDefaultInputDir(boolean isDocker) {
        return isDocker ? DEFAULT_INPUT_DIRECTORY_DOCKER : null;
    }

    protected String getDefaultOutputDir(boolean isDocker) {
        return (String)this.properties.get("ciDefaultOutputDirectory");
    }

    @Option(longName="login", argName="login", shortName="l", required=false)
    @Description(value="Login to access services requiring authentication")
    public void setLogin(String login) {
        this.properties.put("login", login);
    }

    @Option(longName="excelExport", argName="excelExport", shortName="e", required=false)
    @Description(value="Path pattern for excel report export")
    public void setExcelExport(String excelExport) {
        this.properties.put("excelExport", excelExport);
    }

    @Option(longName="uploadConfluencePages", argName="upload", shortName="u", required=false)
    @Description(value="List of the page titles to be uploaded to Confluence. Delimiter is ','. Examples: all; none; type:report; \"Tech of DOMAIN1, Cloud Libraries list\"")
    public void setUploadConfluencePages(String uploadConfluencePages) {
        this.properties.put("/confluence/uploadConfluencePages", uploadConfluencePages);
    }

    @Option(longName="saveProgress", argName="saveProgress", shortName="sp", required=false)
    @Description(value="Save execution progress. That allow restart progress from the specified step.")
    public void setSaveProgress(String saveProgress) {
        this.properties.put("saveProgress", saveProgress);
    }

    @Option(longName="startStep", argName="startStep", shortName="ss", required=false)
    @Description(value="Start execution from the specified step if progress was saved before. See 'saveProgress' property.")
    public void setStartStep(String startStep) {
        this.properties.put("startStep", startStep);
    }

    @Option(longName="lastStep", argName="lastStep", shortName="ls", required=false)
    @Description(value="Last execution step (if progress was saved before). See 'saveProgress' property.")
    public void setLastStep(String lastStep) {
        this.properties.put("lastStep", lastStep);
    }

    @Option(longName="includeDomains", argName="includeDomains", shortName="id", required=false)
    @Description(value="List of Domains that must be processed. Delimiter is ','")
    public void setIncludeDomains(String includeDomains) {
        this.properties.put("includeDomains", includeDomains);
    }

    @Option(longName="disabledFeatures", argName="disabledFeatures", shortName="df", required=false)
    @Description(value="List of the disabled features. Delimiter is ','. Possible: confluenceGenerate,confluenceUpload,excelExport,mavenDependency,repositoryUpdate")
    public void setDisabledFeatures(String disabledFeatures) {
        this.properties.put("disabledFeatures", disabledFeatures);
    }

    @Option(longName="release", argName="release", shortName="r", required=false)
    @Description(value="Release version to be used as a suffix during the export to Confluence")
    public void setRelease(String release) {
        this.properties.put("/release", release);
    }

    @Option(longName="releaseBranch", argName="releaseBranch", shortName="rb", required=false)
    @Description(value="Release version to be used as a suffix during the export to Confluence")
    public void setReleaseBranch(String releaseBranch) {
        this.properties.put("/git/releaseBranch", releaseBranch);
    }

    @Option(longName="priorRelease", argName="priorRelease", shortName="pr", required=false)
    @Description(value="Release version prior to selected release to compare to")
    public void setPriorRelease(String priorRelease) {
        this.properties.put("/priorRelease", priorRelease);
    }

    @Option(longName="passwordSource", argName="passwordSource", shortName="pws", required=false)
    @Description(value="Password source, e.g.: \"file:password.txt\"")
    public void setPasswordSource(String passwordSource) {
        this.properties.put("passwordSource", passwordSource);
    }

    @Option(longName="offline", argName="offline", required=false)
    @Description(value="Offline mode: true/false")
    public void setOfflineMode(String offlineMode) {
        this.properties.put("offlineMode", offlineMode);
    }

    @Option(longName="dockerMode", shortName="docker", argName="dockerMode", required=false)
    @Description(value="Docker mode: true/false")
    public void setDockerMode(boolean dockerMode) {
        this.properties.put("dockerMode", Boolean.toString(dockerMode));
        if (dockerMode) {
            this.properties.put("saveProgress", "false");
        }
    }
}

