/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import com.google.common.reflect.ClassPath;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowMainVerticle
extends AbstractVerticle {
    protected static final Logger LOG = LoggerFactory.getLogger(FlowMainVerticle.class);
    protected final AtomicReference<String> deploymentIdHolder = new AtomicReference();
    protected final Promise<?> flowPromise = Promise.promise();
    @Resource
    protected FlowContext flowContext;
    protected long executionStart;
    private final Handler<Throwable> TERMINATOR = this::terminateFlow;

    protected Logger getLogger() {
        return LOG;
    }

    public JsonObject config() {
        return this.flowContext.getConfig();
    }

    public Future<?> deployAndRunFlow(FlowContext flowContext) {
        flowContext.initialize((Object)this);
        DeploymentOptions options = new DeploymentOptions().setWorker(true).setConfig(flowContext.getConfig());
        this.deployThisVerticle(flowContext.getVertx(), options).onSuccess(depId -> this.deploymentIdHolder.set((String)depId)).onFailure(this.TERMINATOR);
        return this.flowPromise.future();
    }

    public Future<?> undeploy() {
        String deploymentId = this.deploymentIdHolder.getAndSet(null);
        if (deploymentId == null) {
            return Future.succeededFuture();
        }
        return this.vertx.undeploy(deploymentId);
    }

    protected Future<String> deployThisVerticle(Vertx vertx, DeploymentOptions options) {
        return vertx.deployVerticle((Verticle)this, options);
    }

    public void start() throws Exception {
        String startStep;
        List<String> flowSequence;
        this.executionStart = System.nanoTime();
        try {
            flowSequence = this.getFlowSequence();
        }
        catch (Exception e) {
            this.getLogger().error("Error when loading flow sequence", (Throwable)e);
            this.terminateFlow(e);
            return;
        }
        if (CollectionUtils.isEmpty(flowSequence)) {
            this.terminateFlow("No flow defined for " + String.valueOf(((Object)((Object)this)).getClass()));
        }
        if (StringUtils.isBlank((CharSequence)(startStep = this.config().getString("startStep")))) {
            this.getLogger().info("========== Starting a flow: fiid={}", (Object)this.flowContext.getFlowInstanceId());
            startStep = flowSequence.get(0);
        } else {
            this.getLogger().info("========== Starting a flow from '{}': fiid={}", (Object)startStep, (Object)this.flowContext.getFlowInstanceId());
            JsonObject dump = null;
            try {
                dump = JsonUtils.readJsonFile((String)("progress/task." + startStep + ".json"));
            }
            catch (IOException e) {
                this.getLogger().error("Can't restore progress file for '" + startStep + "'", (Throwable)e);
                this.terminateFlow(e);
            }
            if (dump != null) {
                this.flowContext.restoreData(dump);
            } else {
                this.terminateFlow("Can't restore progress file for '" + startStep + "'");
            }
        }
        if (!this.flowPromise.future().failed()) {
            this.deployAndRunTaskSequence(flowSequence, startStep);
        }
    }

    protected void finishFlow() {
        this.getLogger().info("========== Flow execution [fiid={}] completed in {}", (Object)this.flowContext.getFlowInstanceId(), (Object)Duration.ofNanos(System.nanoTime() - this.executionStart));
        this.flowPromise.tryComplete();
    }

    protected void terminateFlow(String message) {
        this.getLogger().info("========== Flow execution [fiid={}] failed: {}", (Object)this.flowContext.getFlowInstanceId(), (Object)message);
        this.flowPromise.tryFail(message);
    }

    protected void terminateFlow(Throwable e) {
        this.getLogger().error("========== Flow execution [fiid=" + this.flowContext.getFlowInstanceId() + "] failed", e);
        this.flowPromise.tryFail(e);
    }

    protected abstract List<String> getFlowSequence() throws Exception;

    protected List<String> loadFlowSequence(String url) throws IOException {
        try (InputStream in = FSUtils.openUrlStream(((Object)((Object)this)).getClass(), (String)url);){
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in, JsonUtils.UTF_8));
            List<String> list = lnr.lines().map(line -> line.replaceFirst("(#|--|//).*$", "").trim()).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            return list;
        }
    }

    protected void deployAndRunTaskSequence(List<String> flowSequence, String startStep) throws Exception {
        Map<String, Class<? extends FlowTask>> taskClasses = this.getTaskClasses(flowSequence);
        ArrayList<FlowTask> taskInstances = new ArrayList<FlowTask>();
        boolean skip = true;
        for (String taskName : flowSequence) {
            if (skip) {
                if (!taskName.equals(startStep)) continue;
                skip = false;
            }
            this.getLogger().debug("Creating task: {}", (Object)taskName);
            taskInstances.add(this.instantiateTask(taskClasses.get(taskName)));
        }
        if (skip) {
            this.terminateFlow("Step '" + startStep + "' not found");
            return;
        }
        Future chainReaction = Future.succeededFuture();
        for (FlowTask taskInstance : taskInstances) {
            chainReaction = chainReaction.compose(r -> taskInstance.startInFlow());
        }
        chainReaction.onFailure(this.TERMINATOR).onSuccess(r -> this.finishFlow());
    }

    private FlowTask instantiateTask(Class<? extends FlowTask> clazz) throws Exception {
        FlowTask taskInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.flowContext.initialize(taskInstance);
        return taskInstance;
    }

    protected Map<String, Class<? extends FlowTask>> getTaskClasses(Collection<String> taskNames) throws IOException, ClassNotFoundException {
        Map taskToPossibleNames = taskNames.stream().distinct().collect(Collectors.toMap(Function.identity(), this::getPossibleClassNames));
        Set simpleNames = taskToPossibleNames.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream()).collect(Collectors.toSet());
        HashMap<String, Class<FlowTask>> classes = new HashMap<String, Class<FlowTask>>();
        ClassLoader taskClassLoader = this.flowContext.getTaskClassLoader();
        for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)taskClassLoader).getTopLevelClasses()) {
            Class<?> clazz;
            String shortName = info.getSimpleName();
            if (!simpleNames.contains(shortName) || Modifier.isAbstract((clazz = Class.forName(info.getName(), false, taskClassLoader)).getModifiers()) || !FlowTask.class.isAssignableFrom(clazz)) continue;
            this.getLogger().debug("Java task found: {}", clazz);
            classes.put(shortName, clazz.asSubclass(FlowTask.class));
        }
        LinkedHashMap<String, Class<? extends FlowTask>> result = new LinkedHashMap<String, Class<? extends FlowTask>>();
        LinkedHashSet<String> missedTasks = new LinkedHashSet<String>();
        for (Map.Entry e2 : taskToPossibleNames.entrySet()) {
            Optional<Class> clazz = e2.getValue().stream().filter(simpleName -> classes.containsKey(simpleName)).findAny().map(simpleName -> (Class)classes.get(simpleName));
            if (clazz.isPresent()) {
                result.put((String)e2.getKey(), clazz.get());
                continue;
            }
            missedTasks.add((String)e2.getKey());
        }
        if (!missedTasks.isEmpty()) {
            throw new IllegalStateException("No implementations found for the following tasks of the flow: " + String.valueOf(missedTasks));
        }
        return result;
    }

    protected Collection<String> getPossibleClassNames(String taskName) {
        String capitalize = StringUtils.capitalize((String)taskName);
        return Arrays.asList(capitalize + "Verticle", capitalize + "Task");
    }
}

