/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.ci;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import java.util.Properties;
import org.qubership.itool.cli.ExecCommand;
import org.qubership.itool.cli.ci.CiAssemblyVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="ci-assembly")
@Summary(value="CI flow: assembly")
public class CiAssemblyCommand
extends ExecCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiAssemblyCommand.class);
    public static final String DEFAULT_OUTPUT_DIRECTORY_DESKTOP = "progress";

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public CiAssemblyCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
        this.properties.put("ciDefaultOutputDirectory", DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
        this.properties.put("ciOutputFile", "assembly.result.json");
    }

    @Override
    public void run() throws CLIException {
        this.getLogger().info("Inventory tool assembly flow execution for CI");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("core version: {}", buildProperties.get("inventory-tool-core.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.logAndFillDirs();
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.getLogger().info("appName: {}", this.properties.get("ciAppName"));
        this.getLogger().info("appVersion: {}", this.properties.get("ciAppVersion"));
        this.runFlow(new CiAssemblyVerticle(), null);
    }

    @Option(longName="inputDirectory", argName="inputDirectory", required=false)
    @Description(value="Input directory. All files within it will be loaded and merged.")
    public void setInputDirectory(String inputDirectory) {
        this.properties.put("ciInputDirectory", inputDirectory);
    }

    @Option(longName="outputDirectory", argName="outputDirectory", required=false)
    @Description(value="Output directory for resulting graph")
    public void setOutputDirectory(String outputDirectory) {
        this.properties.put("ciOutputDirectory", outputDirectory);
    }

    @Option(longName="outputFile", argName="outputFile", required=false)
    @Description(value="Output file name for resulting graph")
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @Option(longName="appName", argName="appName", shortName="appName", required=true)
    @Description(value="Application name, e.g.: \"Inventory-Tool\"")
    public void setAppName(String appName) {
        this.properties.put("ciAppName", appName);
    }

    @Option(longName="appVersion", argName="appVersion", shortName="appVersion", required=false)
    @Description(value="Application version from builder, e.g.: \"main-SNAPSHOT\"")
    public void setAppVersion(String appVersion) {
        this.properties.put("ciAppVersion", appVersion);
    }

    @Override
    @Option(longName="dockerMode", shortName="docker", argName="dockerMode", required=false)
    @Description(value="Docker mode: true/false")
    public void setDockerMode(boolean dockerMode) {
        this.properties.put("ciDefaultOutputDirectory", dockerMode ? "/var/output" : DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
        super.setDockerMode(dockerMode);
    }
}

