/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.ci;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import java.io.File;
import java.util.Properties;
import org.qubership.itool.cli.ExecCommand;
import org.qubership.itool.cli.FlowMainVerticle;
import org.qubership.itool.cli.ci.CiExecApplicationVerticle;
import org.qubership.itool.cli.ci.CiExecVerticle;
import org.qubership.itool.modules.graph.GraphService;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="ci-exec")
@Summary(value="CI flow: parse a single component")
public class CiExecCommand
extends ExecCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiExecCommand.class);
    public static final String DEFAULT_OUTPUT_DIRECTORY_DESKTOP = "progress-ci";

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public CiExecCommand() {
        this.properties.put("ciMockDomain", "orphans");
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
        this.properties.put("ciDefaultOutputDirectory", DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
    }

    @Override
    public void run() throws CLIException {
        this.getLogger().info("Inventory tool main flow execution for CI");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("core version: {}", buildProperties.get("inventory-tool-core.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.logAndFillDirs();
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.getLogger().info("repository: {}", this.properties.get("ciRepository"));
        this.getLogger().info("releaseBranch: {}", this.properties.get("/release"));
        this.getLogger().info("componentName: {}", this.properties.get("ciCompName"));
        this.getLogger().info("componentVersion: {}", this.properties.get("ciCompVersion"));
        GraphService graphService = null;
        this.runFlow(this.createMainVerticle(), graphService);
    }

    protected FlowMainVerticle createMainVerticle() {
        String inputDir = (String)this.properties.get("ciInputDirectory");
        File appInvJson = new File(inputDir, "application_inventory.json");
        boolean appExec = false;
        if (appInvJson.isFile()) {
            this.getLogger().info("File {} exists!", (Object)appInvJson);
            appExec = true;
        } else {
            File appInvJson2 = new File(inputDir, "application-inventory.json");
            if (appInvJson2.isFile()) {
                this.getLogger().warn("File {} exists! Considering it as {}", (Object)appInvJson2, (Object)"application_inventory.json");
                appExec = true;
            }
        }
        if (appExec) {
            this.getLogger().info("==> switching to Application flow");
            return new CiExecApplicationVerticle();
        }
        this.getLogger().info("File {} does NOT exist", (Object)appInvJson);
        this.getLogger().info("==> Normal flow");
        return new CiExecVerticle();
    }

    @Option(longName="componentName", argName="cn", required=true)
    @Description(value="Component name in builder")
    public void setComponentName(String componentName) {
        this.properties.put("ciCompName", componentName);
    }

    @Option(longName="componentVersion", argName="cv", required=false)
    @Description(value="Component version in builder")
    public void setComponentVersion(String componentVersion) {
        this.properties.put("ciCompVersion", componentVersion);
    }

    @Option(longName="repository", argName="repository", required=true)
    @Description(value="Repository of the target component")
    public void setRepository(String repository) {
        if ("null".equals(repository)) {
            LOGGER.error("'null' repository name passed");
            System.exit(1);
        }
        this.properties.put("ciRepository", repository);
        String runName = repository.replaceFirst("^.*/(.*?)(\\.git)?$", "$1");
        this.properties.put("ciRunName", runName);
    }

    @Option(longName="inputDirectory", argName="inputDirectory", required=false)
    @Description(value="Input directory with sources of the target component")
    public void setInputDirectory(String inputDirectory) {
        this.properties.put("ciInputDirectory", inputDirectory);
    }

    @Option(longName="outputDirectory", argName="outputDirectory", required=false)
    @Description(value="Output directory")
    public void setOutputDirectory(String outputDirectory) {
        this.properties.put("ciOutputDirectory", outputDirectory);
    }

    @Option(longName="outputFile", argName="outputFile", required=false)
    @Description(value="Output file name")
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @Option(longName="dumpResultsBy", argName="dumpResultsBy", required=false, choices={"hash", "id", "repo"})
    @Description(value="Strategy for automatic generation of output file name when it is not provided")
    public void setDumpResultsBy(String dumpResults) {
        this.properties.put("ciDumpBy", dumpResults);
    }

    @Override
    @Option(longName="dockerMode", shortName="docker", argName="dockerMode", required=false)
    @Description(value="Docker mode: true/false")
    public void setDockerMode(boolean dockerMode) {
        this.properties.put("ciDefaultOutputDirectory", dockerMode ? "/var/output" : DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
        super.setDockerMode(dockerMode);
    }
}

