/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query;

import java.lang.reflect.Constructor;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.widget.AutopairWidgets;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.MultilineParser;
import org.qubership.itool.cli.query.cmd.CliCommand;
import org.qubership.itool.cli.query.cmd.DoPredefinedQueryCommand;
import org.qubership.itool.cli.query.cmd.ExitCommand;
import org.qubership.itool.cli.query.cmd.GremlinQueryCommand;
import org.qubership.itool.cli.query.cmd.HelpCommand;
import org.qubership.itool.cli.query.cmd.ListPredefinedQueriesCommand;
import org.qubership.itool.cli.query.cmd.NothingCommand;
import org.qubership.itool.cli.query.cmd.PropertyListCommand;
import org.qubership.itool.cli.query.cmd.PropertySetCommand;
import org.qubership.itool.cli.query.cmd.SavePredefinedQueryCommand;
import org.qubership.itool.cli.query.cmd.SaveResultCommand;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.GremlinException;

public class CliQuery {
    private CliContext context;

    public CliQuery(Graph graph) {
        Class[] commands;
        this.context = new CliContext(graph);
        for (Class clazz : commands = new Class[]{DoPredefinedQueryCommand.class, ExitCommand.class, GremlinQueryCommand.class, HelpCommand.class, ListPredefinedQueriesCommand.class, NothingCommand.class, PropertyListCommand.class, PropertySetCommand.class, SavePredefinedQueryCommand.class, SaveResultCommand.class}) {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(CliContext.class);
                CliCommand command = (CliCommand)constructor.newInstance(this.context);
                this.context.getCommands().add(command);
            }
            catch (Exception e) {
                System.err.println("CliCommand registration failed. Reason: " + String.valueOf(e));
            }
        }
    }

    public void run() {
        LineReader reader = LineReaderBuilder.builder().completer((Completer)new AggregateCompleter(new Completer[]{new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"show"}), new NullCompleter()}), new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"show"}), new StringsCompleter(new String[]{"aaa", "access-expression", "access-lists", "accounting", "adjancey"}), new NullCompleter()}), new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"show"}), new StringsCompleter(new String[]{"ip"}), new StringsCompleter(new String[]{"access-lists", "accounting", "admission", "aliases", "arp"}), new NullCompleter()}), new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"show"}), new StringsCompleter(new String[]{"ip"}), new StringsCompleter(new String[]{"interface"}), new StringsCompleter(new String[]{"ATM", "Async", "BVI"}), new NullCompleter()})})).parser((Parser)new MultilineParser()).build();
        AutopairWidgets autopairWidgets = new AutopairWidgets(reader);
        autopairWidgets.enable();
        block5: while (true) {
            try {
                while (true) {
                    String userInput = reader.readLine(this.getPrompt()).trim();
                    try {
                        this.executeGremlinQuery(userInput);
                        continue block5;
                    }
                    catch (GremlinException ge) {
                        System.out.println("Unknown userInput:");
                        System.out.println(userInput);
                        continue;
                    }
                    break;
                }
            }
            catch (UserInterruptException userInterruptException) {
                continue;
            }
            catch (EndOfFileException endOfFileException) {
                continue;
            }
            break;
        }
    }

    public Object executeGremlinQuery(String query) throws GremlinException {
        Object result = null;
        boolean accepted = false;
        for (CliCommand command : this.context.getCommands()) {
            if (!command.acceptCommand(query)) continue;
            accepted = true;
            result = command.doCommand(query);
            break;
        }
        if (!accepted) {
            throw new GremlinException("Can't process query. Reason: command not found");
        }
        return result;
    }

    private String getPrompt() {
        return "Gremlin> ";
    }
}

