/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.cli.query.QueryItem;
import org.qubership.itool.utils.FSUtils;

public class QueryFileParser {
    public void parse(List<QueryItem> queryItems, String fileName) {
        String source;
        try {
            source = FSUtils.readFileSafe((String)fileName);
        }
        catch (IOException e) {
            System.out.println("Failed to read predefined queries");
            return;
        }
        String method = null;
        String description = null;
        Object query = "";
        STATE state = STATE.init;
        block7: for (String row : source.split("\n\r|\r\n|\r|\n")) {
            if (row.startsWith("#") || StringUtils.isBlank((CharSequence)row) && state.equals((Object)STATE.init)) continue;
            if (StringUtils.isBlank((CharSequence)row) && state.equals((Object)STATE.query)) {
                QueryItem queryItem = new QueryItem(method, description, (String)query);
                queryItems.add(queryItem);
                method = null;
                description = null;
                query = "";
                state = STATE.method;
                continue;
            }
            switch (state.ordinal()) {
                case 0: 
                case 1: {
                    method = row;
                    state = STATE.description;
                    continue block7;
                }
                case 2: {
                    description = row;
                    state = STATE.query;
                    continue block7;
                }
                case 3: {
                    query = (String)query + row + "\n";
                }
            }
        }
    }

    private static enum STATE {
        init,
        method,
        description,
        query;

    }
}

