/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.Map;
import java.util.Properties;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.query.QueryExecutor;
import org.qubership.itool.modules.query.converter.ToTextConverter;

public class GremlinQueryCommand
extends AbstractCliCommand {
    public static final String LAST_EXECUTED_QUERY = "lastExecutedQuery";
    public static final String LAST_EXECUTED_RESULT = "lastExecutedResult";

    public GremlinQueryCommand(CliContext context) {
        super(context);
    }

    @Override
    public String name() {
        return ".XXX;";
    }

    @Override
    public String description() {
        return "Execute Gremlin query. Where XXX can be V() for Verticles or .E() for Edges";
    }

    @Override
    public boolean acceptCommand(String command) {
        return command.startsWith(".V(") || command.startsWith(".E(");
    }

    @Override
    public Object doCommand(String command) {
        try {
            long startTime = System.currentTimeMillis();
            QueryExecutor queryConverter = new QueryExecutor((BasicGraph)this.context().getGraph());
            Object result = queryConverter.executeGremlinQuery(command);
            this.printGremlinResult(startTime, result);
            this.context().setValue(LAST_EXECUTED_QUERY, command);
            this.context().setValue(LAST_EXECUTED_RESULT, result);
            return result;
        }
        catch (GremlinException ge) {
            System.out.println(ge.getMessage());
        }
        catch (Exception e) {
            System.out.println("Unexpected exception: " + e.getMessage());
        }
        return null;
    }

    private void printGremlinResult(long startTime, Object result) {
        ToTextConverter converter = new ToTextConverter();
        converter.setProperties((Properties)this.context().getValue("properties"));
        String output = (String)converter.convert(result);
        long endTime = System.currentTimeMillis();
        System.out.print(output);
        System.out.println("Execution time (ms): " + (endTime - startTime));
    }

    private void printMap(Map map) {
        if (map == null) {
            System.out.println("map is null");
            return;
        }
        System.out.println(map);
    }
}

