/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;

public class SaveResultCommand
extends AbstractCliCommand {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("save result\\(\"(\\w+)\"(?:,\\s\"(.*)\")\\);");

    public SaveResultCommand(CliContext context) {
        super(context);
    }

    @Override
    public String name() {
        return "save result(format, filePath);";
    }

    @Override
    public String description() {
        return "Save query result to the file on the specified format (json, txt)";
    }

    @Override
    public boolean acceptCommand(String command) {
        return command.startsWith("save result(");
    }

    @Override
    public Object doCommand(String command) {
        Matcher matcher = COMMAND_PATTERN.matcher(command);
        if (!matcher.matches()) {
            System.out.println("Wrong command. Example: save result(\"txt\", \"all_microservices.txt\");");
            return null;
        }
        Object result = this.context().getValue("lastExecutedResult");
        if (result == null) {
            System.out.println("Gremlin query result not found");
            return null;
        }
        String fileFormat = matcher.group(1);
        String fileName = matcher.group(2);
        String fileSource = this.convertResult(result, fileFormat);
        if (fileSource == null) {
            System.out.println("Can't save result in the specified format");
        }
        return null;
    }

    private String convertResult(Object result, String fileFormat) {
        if ("txt".equals(fileFormat.toLowerCase())) {
            // empty if block
        }
        return null;
    }
}

