/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.context;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.modules.confluence.ConfluenceClient;
import org.qubership.itool.modules.confluence.ConfluenceClientBuilder;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.DiagramServiceImpl;
import org.qubership.itool.modules.diagram.providers.DiagramProvider;
import org.qubership.itool.modules.diagram.providers.DomainDiagramProvider;
import org.qubership.itool.modules.diagram.providers.GeneralDomainsDiagramProvider;
import org.qubership.itool.modules.diagram.providers.InfrastructureDiagramProvider;
import org.qubership.itool.modules.diagram.providers.MicroserviceDiagramProvider;
import org.qubership.itool.modules.diagram.providers.QueueDiagramProvider;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitAdapterBuilder;
import org.qubership.itool.modules.git.GitFileRetriever;
import org.qubership.itool.modules.git.GitFileRetrieverBuilder;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphClassifier;
import org.qubership.itool.modules.graph.GraphClassifierBuilderImpl;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.graph.GraphImpl;
import org.qubership.itool.modules.graph.GraphService;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.modules.report.GraphReportImpl;
import org.qubership.itool.modules.template.TemplateService;
import org.qubership.itool.modules.template.TemplateServiceImpl;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowContextImpl
implements FlowContext {
    private static final Logger LOG = LoggerFactory.getLogger(FlowContextImpl.class);
    private TemplateService templateService;
    private DiagramService diagramService;
    private final String flowInstanceId = UUID.randomUUID().toString();
    private final Map<Class<?>, Object> resources = new HashMap();
    private final Graph graph;
    private final GraphService graphService;
    private GraphClassifier graphClassifier;
    private GraphReport report;
    private JsonObject config;
    private ClassLoader taskClassLoader;
    private Vertx vertx;
    private boolean breakRequested;

    public FlowContextImpl() {
        this((GraphService)null);
    }

    public FlowContextImpl(Graph graph) {
        this.graph = graph;
        this.report = graph.getReport();
        this.graphService = null;
    }

    public FlowContextImpl(GraphService graphService) {
        this.report = new GraphReportImpl();
        this.graph = new GraphImpl();
        this.graph.setReport(this.report);
        this.graphService = graphService;
        if (graphService != null) {
            this.graphClassifier = new GraphClassifierBuilderImpl().setId("flow-" + this.flowInstanceId).setWithReport(true).build();
            graphService.putGraph(this.graphClassifier, this.graph);
            LOG.info("[fiid={}]: Graph @{} created for {}", new Object[]{this.flowInstanceId, System.identityHashCode(this.graph), this.graphClassifier});
        } else {
            LOG.info("[fiid={}]: Graph @{} created, not attached to graph service", (Object)this.flowInstanceId, (Object)System.identityHashCode(this.graph));
        }
    }

    @Override
    public void initialize(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        Properties diagramProperties = new Properties();
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.default.domain", "Gold");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.default.component", "Yellow");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.database", "DeepSkyBlue");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.queue", "GreenYellow");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.caching", "Orchid");
        this.diagramService = new DiagramServiceImpl(this.getGraph(), diagramProperties);
        this.diagramService.register((DiagramProvider)new MicroserviceDiagramProvider());
        this.diagramService.register((DiagramProvider)new DomainDiagramProvider());
        this.diagramService.register((DiagramProvider)new GeneralDomainsDiagramProvider());
        this.diagramService.register((DiagramProvider)new InfrastructureDiagramProvider());
        this.diagramService.register((DiagramProvider)new QueueDiagramProvider());
        this.templateService = new TemplateServiceImpl(this.diagramService, config);
        WebClient client = WebClient.create((Vertx)vertx);
        GitAdapter gitAdapter = GitAdapterBuilder.create((Vertx)vertx, (GraphReport)this.report, (JsonObject)config);
        ConfluenceClient confluenceClient = ConfluenceClientBuilder.create((Vertx)vertx, (WebClient)client, (JsonObject)config);
        GitFileRetriever gitFileRetriever = GitFileRetrieverBuilder.create((GitAdapter)gitAdapter, (JsonObject)config, (Vertx)vertx, (GraphReport)this.report);
        this.resources.put(FlowContext.class, this);
        this.resources.put(Vertx.class, vertx);
        this.resources.put(Graph.class, this.graph);
        this.resources.put(GraphReport.class, this.report);
        this.resources.put(WebClient.class, client);
        this.resources.put(ConfluenceClient.class, confluenceClient);
        this.resources.put(DiagramService.class, this.diagramService);
        this.resources.put(TemplateService.class, this.templateService);
        this.resources.put(GitAdapter.class, gitAdapter);
        this.resources.put(GitFileRetriever.class, gitFileRetriever);
        if (this.graphService != null) {
            this.resources.put(GraphService.class, this.graphService);
        }
        if (this.graphClassifier != null) {
            this.resources.put(GraphClassifier.class, this.graphClassifier);
        }
    }

    @Override
    public void initialize(Object task) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = task.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        this.setAnnotatedFieldValues(task, fields);
        LOG.debug("Dependency injections for task {} complete", task);
    }

    @Override
    public <T> T getResource(Class<T> clazz) {
        return (T)this.resources.get(clazz);
    }

    @Override
    public Map<Class<?>, Object> getResources() {
        return this.resources;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public GraphReport getReport() {
        return this.report;
    }

    private void setAnnotatedFieldValues(Object obj, List<Field> fields) {
        for (Field field : fields) {
            Resource annotation = field.getDeclaredAnnotation(Resource.class);
            if (annotation == null) continue;
            Object resource = this.resources.get(field.getType());
            if (resource != null) {
                this.setFieldValue(obj, field, resource);
                LOG.trace("Field {} of {} was updated with value {}", new Object[]{field.getName(), obj, resource});
                continue;
            }
            if (this.resources.containsKey(field.getType()) && field.getDeclaredAnnotation(Nullable.class) != null) {
                LOG.warn("No resource provided for " + String.valueOf(field.getType()) + " in " + obj.getClass().getName());
                continue;
            }
            throw new IllegalArgumentException("Resource not found for " + String.valueOf(field.getType()) + " in " + obj.getClass().getName());
        }
    }

    private void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            LOG.error("Can't initialize " + String.valueOf(field.getType()) + " in the " + obj.getClass().getName() + ". Reason: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dumpDataToFile(File folder, String file) {
        JsonObject dump = GraphDumpSupport.dumpToJson((Graph)this.graph, (boolean)false);
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        File progressFile = new File(folder, file);
        try {
            JsonUtils.saveJson((Path)progressFile.toPath(), (Object)dump, (boolean)true);
        }
        catch (IOException e) {
            LOG.error("Exception when saving progress file " + String.valueOf(progressFile), (Throwable)e);
        }
    }

    @Override
    public void restoreData(JsonObject dump) {
        GraphDumpSupport.restoreFromJson((Graph)this.graph, (JsonObject)dump);
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }

    @Override
    public ClassLoader getTaskClassLoader() {
        return this.taskClassLoader;
    }

    public void setTaskClassLoader(ClassLoader taskClassLoader) {
        this.taskClassLoader = taskClassLoader;
    }

    @Override
    public void setBreakRequested(boolean breakRequested) {
        this.breakRequested = breakRequested;
    }

    @Override
    public boolean isBreakRequested() {
        return this.breakRequested;
    }

    @Override
    public String getFlowInstanceId() {
        return this.flowInstanceId;
    }

    @Override
    public GraphClassifier getGraphClassifier() {
        return this.graphClassifier;
    }
}

