/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.factories;

import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.impl.JavaVerticleFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VerticleFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaAppContextVerticleFactory
extends JavaVerticleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JavaAppContextVerticleFactory.class);
    protected FlowContext applicationContext;
    protected Path customTaskPath;
    protected ClassLoader taskClassLoader;

    public JavaAppContextVerticleFactory(FlowContext applicationContext, JsonObject config) {
        this.applicationContext = applicationContext;
        ClassLoader parentCl = Thread.currentThread().getContextClassLoader();
        if (parentCl == null) {
            parentCl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this.customTaskPath = Path.of(StringUtils.defaultString((String)ConfigUtils.getConfigValue((String)"/configPath", (JsonObject)config), (String)"."), "default", "tasks");
        if (!Files.isDirectory(this.customTaskPath, new LinkOption[0])) {
            LOG.warn("Path {} does not exist or is not directory", (Object)this.customTaskPath);
            this.taskClassLoader = parentCl;
            this.customTaskPath = null;
            return;
        }
        try {
            this.taskClassLoader = new URLClassLoader(new URL[]{this.customTaskPath.toUri().toURL()}, parentCl);
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to convert Path " + String.valueOf(this.customTaskPath) + " to URL", (Throwable)e);
            this.taskClassLoader = parentCl;
        }
    }

    public void createVerticle(String verticleName, ClassLoader parentClassLoader, Promise<Callable<Verticle>> promise) {
        LOG.debug(verticleName);
        verticleName = VerticleFactory.removePrefix((String)verticleName);
        Class<?> clazz = null;
        try {
            clazz = this.taskClassLoader.loadClass(verticleName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = parentClassLoader.loadClass(verticleName);
            }
            catch (ClassNotFoundException e) {
                promise.fail((Throwable)e);
                return;
            }
        }
        Class<?> finalClazz = clazz;
        promise.complete(() -> {
            Verticle verticle = (Verticle)finalClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.applicationContext.initialize(verticle);
            return verticle;
        });
    }

    public int order() {
        return -10;
    }

    public ClassLoader getTaskClassLoader() {
        return this.taskClassLoader;
    }

    public Path getCustomTaskPath() {
        return this.customTaskPath;
    }
}

