/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.parsing;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;

public class InventoryJsonParser {
    public void parse(JsonObject domain, JsonObject component, String inventorySource) {
        this.parse(domain, component, new JsonObject(inventorySource));
    }

    public void parse(JsonObject domain, JsonObject component, JsonObject inventoryJson) {
        this.fillDetails(domain, component, inventoryJson);
        this.fillFeatures(component, inventoryJson);
    }

    private void fillDetails(JsonObject domain, JsonObject component, JsonObject inventoryJson) {
        JsonObject detailsJson = JsonUtils.getOrCreateJsonObject((JsonObject)component, (String)"details");
        String abbreviation = inventoryJson.getString("id");
        detailsJson.put("abbreviation", (Object)abbreviation);
        component.put("abbreviation", (Object)abbreviation);
        String name = inventoryJson.getString("name");
        detailsJson.put("name", (Object)name);
        component.put("name", (Object)name);
        String owner = inventoryJson.getString("owner");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"owner", (Object)owner);
        String dnsName = inventoryJson.getString("dnsName");
        JsonArray altDnsNames = inventoryJson.getJsonArray("altDnsNames");
        InventoryJsonParser.fillDnsNames(detailsJson, dnsName, altDnsNames);
        String domainFromInventory = inventoryJson.getString("domain");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"domainFromInventory", (Object)domainFromInventory);
        detailsJson.put("domain", domain.getValue("id"));
        String description = inventoryJson.getString("description");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"description", (Object)description);
        String type = inventoryJson.getString("type");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"type", (Object)type);
        JsonUtils.putValueIfNotNull((JsonObject)component, (String)"type", (Object)type);
        Object framework = inventoryJson.getValue("framework");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"framework", (Object)JsonUtils.convertListToFilteredString((Object)framework));
        JsonArray documentation = inventoryJson.getJsonArray("documentation");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"documentationLink", (Object)documentation);
        JsonObject tmfSpec = inventoryJson.getJsonObject("tmfSpec");
        if (tmfSpec != null) {
            detailsJson.put("tmfSpec", (Object)InventoryJsonParser.convertToLegacyTmfSpec(tmfSpec));
        }
        Object language = inventoryJson.getValue("language");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"language", (Object)LanguageUtils.convertListToLanguages((Object)language));
        this.fillApiDocumentation(detailsJson, inventoryJson);
        this.processDatabases(detailsJson, inventoryJson);
        this.processQueues(detailsJson, inventoryJson);
        JsonObject dependency = inventoryJson.getJsonObject("dependency");
        JsonUtils.putValueIfNotNull((JsonObject)detailsJson, (String)"dependencies", (Object)dependency);
        JsonUtils.copyValueIfNotNull((JsonObject)inventoryJson, (JsonObject)detailsJson, (String)"thirdparty");
    }

    private static void fillDnsNames(JsonObject detailsJson, String dnsName, JsonArray altDnsNames) {
        JsonArray dnsNames = new JsonArray();
        if (dnsName != null) {
            detailsJson.put("dnsName", (Object)dnsName);
            dnsNames.add((Object)dnsName);
        }
        if (altDnsNames != null) {
            dnsNames.addAll(altDnsNames);
        }
        detailsJson.put("dnsNames", (Object)dnsNames);
    }

    private void fillApiDocumentation(JsonObject details, JsonObject inventoryJson) {
        Object apisp;
        JsonObject apiJson = new JsonObject();
        details.put("api", (Object)apiJson);
        Boolean openApi = inventoryJson.getBoolean("openApi", Boolean.valueOf(false));
        if (openApi != null) {
            apiJson.put("openApi", (Object)(openApi != false ? "yes" : "no"));
        }
        if ((apisp = inventoryJson.getValue("openAPIpublished")) instanceof JsonArray) {
            JsonArray apiSpecPublished = (JsonArray)apisp;
            apiJson.put("apiSpecPublished", (Object)apiSpecPublished);
        } else if (apisp instanceof String) {
            JsonArray apiSpecPublished = new JsonArray().add(apisp);
            apiJson.put("apiSpecPublished", (Object)apiSpecPublished);
        }
    }

    private void processDatabases(JsonObject details, JsonObject inventoryJson) {
        JsonArray source = inventoryJson.getJsonArray("database");
        if (source == null) {
            return;
        }
        JsonArray target = JsonUtils.getOrCreateJsonArray((JsonObject)details, (JsonPointer)JsonPointer.from((String)"/database/database"));
        for (Object o : source) {
            JsonObject jo = JsonUtils.asJsonObject(o);
            Object name = jo.getString("name");
            String version = jo.getString("version");
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                name = (String)name + " " + version;
            }
            JsonObject dbItem = new JsonObject().put("item", name).put("viaZookeeper", (Object)"no");
            target.add((Object)dbItem);
        }
    }

    private void processQueues(JsonObject details, JsonObject inventoryJson) {
        JsonArray source = inventoryJson.getJsonArray("queue");
        if (source == null) {
            return;
        }
        JsonObject target = JsonUtils.getOrCreateJsonObject((JsonObject)details, (String)"messageQueues");
        for (Object o : source) {
            JsonObject jo = (JsonObject)o;
            String type = jo.getString("type", "").toLowerCase();
            if ("rabbitmq".equals(type)) {
                type = "rabbitMQ";
            }
            String role = jo.getString("role", "consumer");
            String qName = jo.getString("name", "");
            JsonObject qtype = JsonUtils.getOrCreateJsonObject((JsonObject)target, (String)type);
            JsonUtils.getOrCreateJsonArray((JsonObject)qtype, (String)role).add((Object)qName);
        }
    }

    private void fillFeatures(JsonObject component, JsonObject inventoryJson) {
        JsonObject featuresJson = new JsonObject();
        component.put("features", (Object)featuresJson);
        this.parseFeaturesMultitenancy(featuresJson, inventoryJson);
    }

    private void parseFeaturesMultitenancy(JsonObject featuresJson, JsonObject inventoryJson) {
        JsonObject multitenancyJson = new JsonObject();
        featuresJson.put("multitenancy", (Object)multitenancyJson);
        String defaultTenantId = (Boolean)JsonPointer.from((String)"/multitenancy/defaultTenantId").queryJsonOrDefault((Object)inventoryJson, (Object)Boolean.FALSE) != false ? "yes" : "no";
        multitenancyJson.put("defaultTenantId", (Object)defaultTenantId);
    }

    private static JsonArray convertToLegacyTmfSpec(JsonObject spec) {
        JsonArray result = new JsonArray();
        for (Map.Entry item : spec.getMap().entrySet()) {
            String tmfSpecNumber = (String)item.getKey();
            for (String tmfSpecVersion : InventoryJsonParser.getVersions(new JsonObject((Map)item.getValue()))) {
                result.add((Object)(tmfSpecNumber + " v" + tmfSpecVersion));
            }
        }
        return result;
    }

    private static List<String> getVersions(JsonObject version) {
        if (version == null) {
            return Collections.emptyList();
        }
        Object tmfSpecVersions = version.getValue("version");
        if (tmfSpecVersions == null) {
            return Collections.emptyList();
        }
        if (tmfSpecVersions instanceof JsonArray) {
            return ((JsonArray)tmfSpecVersions).getList();
        }
        if (tmfSpecVersions instanceof String) {
            return Collections.singletonList((String)tmfSpecVersions);
        }
        return Collections.singletonList(version.getString("version"));
    }
}

