/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.ci;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import org.apache.maven.shared.utils.StringUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.GraphMetaInfoSupport;
import org.qubership.itool.tasks.FlowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeMockDomainVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(InitializeMockDomainVerticle.class);

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        JsonObject config = this.config();
        String directoryPath = config.getString("ciInputDirectory");
        String repository = config.getString("ciRepository");
        String domainName = config.getString("ciMockDomain");
        String releaseBranch = (String)JsonPointer.from((String)"/git/releaseBranch").queryJson((Object)config);
        String componentId = InitializeMockDomainVerticle.findFirst(config.getString("ciCompName"), config.getString("ciRunName"), "unknown");
        String componentName = InitializeMockDomainVerticle.findFirst(config.getString("ciCompName"), "unknown");
        String componentVersion = InitializeMockDomainVerticle.findFirst(config.getString("ciCompVersion"), "unknown");
        JsonObject mockDomain = new JsonObject().put("id", (Object)domainName).put("type", (Object)"domain").put("department", (Object)"unknown").put("isMock", (Object)true);
        this.graph.addVertexUnderRoot(mockDomain);
        JsonObject component = new JsonObject().put("id", (Object)componentId).put("isMock", (Object)true).put("type", (Object)"unknown").put("directoryPath", (Object)directoryPath).put("releaseBranch", (Object)releaseBranch).put("repository", (Object)repository);
        this.getLogger().info("Seed component created: {}", (Object)component);
        JsonPointer.from((String)"/details/domain").writeJson((Object)component, (Object)domainName, true);
        JsonPointer.from((String)"/details/releaseBranch").writeJson((Object)component, (Object)releaseBranch, true);
        this.graph.addVertex(mockDomain, component);
        GraphMetaInfoSupport.initMetaInfoForComponent((Graph)this.graph, (String)componentName, (String)componentVersion);
        this.taskCompleted(taskPromise);
    }

    private static String findFirst(String ... strings) {
        for (String s : strings) {
            if (!StringUtils.isNotBlank((String)s)) continue;
            return s;
        }
        return "unknown";
    }
}

