/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import freemarker.template.TemplateMethodModelEx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.parser.OpenApi3Parser;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.gremlin2.structure.MapElement;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.DiagramMicroserviceMethod;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceGenerateComponentPagesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    @Resource
    protected DiagramService diagramService;
    public static final List<String> BACKEND_TYPES = Arrays.asList("backend", "ui backend");
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceGenerateComponentPagesVerticle.class);

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        List components = this.V(new String[0]).hasType(new String[]{"domain"}).has("department", department).out(new String[0]).hasKeys(new String[]{"/details/domain"}).toList();
        for (JsonObject component : components) {
            String framework;
            String domain = (String)JsonPointer.from((String)"/details/domain").queryJson((Object)component);
            String componentId = component.getString("id");
            this.getLogger().info("Processing: {}", (Object)componentId);
            if (null == domain) {
                this.report.mandatoryValueMissed(component, "Domain name");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)component.getString("name"))) {
                this.report.mandatoryValueMissed(component, "Component name");
                continue;
            }
            String publicDomainId = this.getPublicDomainId(domain);
            String pageTitle = "Tech of " + publicDomainId + "." + component.getString("name");
            String parentTitle = "Tech of " + publicDomainId;
            ConfluencePage page = new ConfluencePage();
            confluencePageList.add(page);
            page.setElement(component);
            page.setElementType("component");
            page.setTitle(pageTitle);
            page.setParentTitle(parentTitle);
            page.setType("component");
            page.setTemplate("componentPage.ftlh");
            page.setDirectoryPath(department + "/" + domain);
            page.setFileName(componentId);
            String languages = LanguageUtils.getLanguagesAsString((BasicGraph)this.graph, (JsonObject)component);
            if (!StringUtils.isEmpty((CharSequence)languages)) {
                page.addDataModel("language", (Object)languages);
            }
            if ((framework = (String)JsonPointer.from((String)"/details/framework").queryJson((Object)component)) != null && !framework.isEmpty()) {
                List<String> frameworks = Arrays.asList(framework.split("\\s*,\\s*"));
                page.addDataModel("framework", (Object)String.join((CharSequence)", ", TechNormalizationHelper.normalizeTechs(frameworks)));
            }
            List artifacts = this.V(componentId).out(new String[]{"module"}).order().by("id").toList();
            page.addDataModel("artifacts", (Object)artifacts);
            GraphTraversal directTraversal = this.V(componentId).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("transitive", P.neq((Object)true)).has("scope", P.neq((Object)"test")).has("component", componentId).inV().dedup();
            List directDependencies = directTraversal.clone().order().by("id").toList();
            page.addDataModel("directDependencies", (Object)directDependencies);
            List transitiveDependencies = LanguageUtils.hasLanguage((BasicGraph)this.graph, (JsonObject)component, (String)"GoLang") ? this.V(componentId).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("transitive", P.eq((Object)true)).has("component", componentId).inV().dedup().order().by("id").toList() : directTraversal.clone().outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", componentId).inV().dedup().repeat((Traversal)__.outE((String[])new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", componentId).inV().dedup()).emit().dedup().order().by("id").toList();
            page.addDataModel("transitiveDependencies", (Object)transitiveDependencies);
            List groupIdDuplicated = directTraversal.clone().repeat((Traversal)__.outE((String[])new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", componentId).inV().dedup()).emit().dedup().values(new String[]{"groupId", "version"}).dedup().group().by("groupId").by("version").unfold().by(MapElement.both).where((Traversal)__.value().size().is((Object)P.gt((Object)1))).order().by(MapElement.key).toList();
            page.addDataModel("groupIdDuplicated", (Object)groupIdDuplicated);
            this.addOpenApiSpecification(page, component);
            List outDependenciesList = this.V(componentId).outE(new String[0]).has("type", P.without((Object[])new String[]{"module", "info", "implemented"})).type().as("type", new String[0]).inV().where((Traversal)__.in((String[])new String[0]).hasType(new String[]{"domain"})).values(new String[]{"name", "id", "/details/domain", "/details/owner"}).as("component", new String[0]).select(new String[]{"component", "type"}).dedup().toList();
            page.addDataModel("outDependenciesList", (Object)outDependenciesList);
            List inDependenciesList = this.V(componentId).inE(new String[0]).has("type", P.without((Object[])new String[]{"module", "info", "implemented"})).type().as("type", new String[0]).outV().where((Traversal)__.in((String[])new String[0]).hasType(new String[]{"domain"})).values(new String[]{"name", "id", "/details/domain", "/details/owner"}).as("component", new String[0]).select(new String[]{"component", "type"}).dedup().toList();
            page.addDataModel("inDependenciesList", (Object)inDependenciesList);
            List supportedGatewayList = this.V(componentId).out(new String[0]).hasType(new String[]{"gateway"}).value("id").toList();
            if (CollectionUtils.isNotEmpty((Collection)supportedGatewayList)) {
                page.addDataModel("gateways", (Object)supportedGatewayList);
            }
            List directErrorCodes = this.V(componentId).out(new String[]{"errorCode"}).toList();
            page.addDataModel("directErrorCodes", (Object)directErrorCodes);
            List indirectErrorCodes = this.V(componentId).repeat((Traversal)__.out((String[])new String[]{"optional", "mandatory", "library"}).hasNotId(new String[]{componentId}).where((Traversal)__.in((String[])new String[0]).hasType(new String[]{"domain"}))).emit().dedup().out(new String[]{"errorCode"}).toList();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(department);
            arguments.add(domain);
            arguments.add(componentId);
            DiagramMicroserviceMethod diagramMicroserviceMethod = new DiagramMicroserviceMethod(this.diagramService);
            String encodedText = this.buildDiagramImageURL((TemplateMethodModelEx)diagramMicroserviceMethod, arguments);
            if (encodedText != null) {
                page.addDataModel("encodedDiagramMicroservice", (Object)encodedText);
            }
            page.addDataModel("indirectErrorCodes", (Object)indirectErrorCodes);
            page.addDataModel("totalErrorCodesCount", (Object)(directErrorCodes.size() + indirectErrorCodes.size()));
        }
        return confluencePageList;
    }

    private void addOpenApiSpecification(ConfluencePage page, JsonObject component) {
        if (!BACKEND_TYPES.contains(component.getString("type"))) {
            return;
        }
        String openApiSpecPath = component.getString("openApiSpecPath");
        if (openApiSpecPath == null) {
            return;
        }
        try {
            OpenApi3 parser = (OpenApi3)new OpenApi3Parser().parse(new File(openApiSpecPath), false);
            page.addDataModel("openApi", (Object)parser);
        }
        catch (ResolutionException | ValidationException e) {
            this.LOG.warn("Can't parse OpenApi spec for " + component.getString("id"));
            this.report.exceptionThrown(component, (Exception)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

