/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import freemarker.template.TemplateMethodModelEx;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.DiagramDomainMethod;
import org.qubership.itool.modules.template.DiagramGeneralDomainMethod;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceGenerateDomainPagesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceGenerateDomainPagesVerticle.class);
    @Resource
    protected DiagramService diagramService;

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        List domainIdList = this.V(new String[0]).hasType(new String[]{"domain"}).has("department", P.eq((Object)department)).toList();
        for (JsonObject domain : domainIdList) {
            DiagramDomainMethod diagramDomainMethod;
            String domainId = domain.getString("id");
            ConfluencePage page = new ConfluencePage();
            confluencePageList.add(page);
            page.setElement(domain);
            page.setElementType("domain");
            page.setTitle("Tech of " + this.getPublicDomainId(domainId));
            page.setParentTitle("Tech of cloud " + department);
            page.setType("domain");
            page.setTemplate("domainPage.ftlh");
            page.setDirectoryPath(department + "/" + domainId);
            page.setFileName("domainPage");
            List components = this.V(domainId).out(new String[0]).as("C", new String[0]).local((Traversal)__.in((String[])new String[0]).where((Traversal)__.not((Traversal)__.hasType((String[])new String[]{"domain"}))).count()).as("T", new String[0]).select(new String[]{"C", "T"}).toList();
            page.addDataModel("components", (Object)components);
            List techStack = this.V(domainId).out(new String[0]).out(new String[0]).where((Traversal)__.in((String[])new String[0]).hasId(new String[]{"Infra", "Info"})).not((Traversal)__.has((String)"type", (String)"gateway")).name().dedup().order().toList();
            page.addDataModel("techStack", (Object)techStack);
            List techStackByService = this.V(domainId).out(new String[0]).as("C", new String[0]).local((Traversal)__.out((String[])new String[0]).where((Traversal)__.in((String[])new String[0]).hasId(new String[]{"Infra", "Info"})).not((Traversal)__.has((String)"type", (String)"gateway")).name().dedup().fold()).as("T", new String[0]).select(new String[]{"C", "T"}).values(new String[]{"abbreviation:/C/details/abbreviation", "name:/C/name", "apiSpec:/C/details/api/apiSpecPublished", "usedTech:/T"}).order().by("name").toList();
            page.addDataModel("techStackByService", (Object)techStackByService);
            List tmfSpecList = this.V(domainId).out(new String[0]).as("C", new String[0]).out(new String[0]).where((Traversal)__.in((String[])new String[0]).hasId(new String[]{"Spec"})).as("S", new String[0]).select(new String[]{"C", "S"}).toList();
            page.addDataModel("tmfSpecs", (Object)tmfSpecList);
            List blueGreenReady = this.V(domainId).out(new String[0]).hasType(new String[]{"backend"}).not((Traversal)__.has((String)"/details/deploymentConfiguration/deployOptions/bluegreen", (P)P.eq((Object)true))).values(new String[]{"id", "/details/abbreviation", "name"}).toList();
            page.addDataModel("blueGreenReady", (Object)blueGreenReady);
            List faultToleranceSupport = this.V(domainId).out(new String[0]).values(new String[]{"id", "name", "/details/abbreviation", "/features/faultTolerance"}).as("C", new String[0]).value("faultTolerance").union(new Traversal[]{__.has((String)"errorCodes", (P)P.within((Object[])new String[]{"not required", "no"})).key().is((Object)P.eq((Object)"errorCodes")).as("T", new String[0]), __.has((String)"httpRetryPolicy", (P)P.within((Object[])new String[]{"not required", "no"})).key().is((Object)P.eq((Object)"httpRetryPolicy")).as("T", new String[0]), __.has((String)"customHealthProbes", (P)P.within((Object[])new String[]{"not required", "no"})).key().is((Object)P.eq((Object)"customHealthProbes")).as("T", new String[0])}).select(new String[]{"C", "T"}).group().by("C").by("T").toList();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(department);
            arguments.add(domainId);
            DiagramGeneralDomainMethod diagramGeneralDomainMethod = new DiagramGeneralDomainMethod(this.diagramService);
            String encodedText = this.buildDiagramImageURL((TemplateMethodModelEx)diagramGeneralDomainMethod, arguments);
            if (encodedText != null) {
                page.addDataModel("encodedDiagramGeneralDomain", (Object)encodedText);
            }
            if ((encodedText = this.buildDiagramImageURL((TemplateMethodModelEx)(diagramDomainMethod = new DiagramDomainMethod(this.diagramService)), arguments)) != null) {
                page.addDataModel("encodedDiagramDomain", (Object)encodedText);
            }
            page.addDataModel("faultToleranceSupport", (Object)faultToleranceSupport);
        }
        return confluencePageList;
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

