/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.qubership.itool.modules.confluence.ConfluenceClient;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUploadPagesVerticle
extends AbstractAggregationTaskVerticle {
    public static final String TRASH_PAGE_NAME = "TRASH";
    public static final String STRUCT_TYPE = "type";
    public static final String STRUCT_CHILDREN = "children";
    public static final String PAGE_TITLE = "title";
    public static final String PAGE_PARENT_TITLE = "parentTitle";
    public static final String PAGE_ON_DISK_PATH = "onDiskPath";
    public static final String PAGE_PARENT_ID = "parentId";
    public static final String PAGE_ID = "id";
    public static final String PAGE_TYPE = "type";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_MOVE = "move";
    public static final String ACTION_KEY_GENERATED_PAGE = "generatedPage";
    public static final String ACTION_KEY_CONFLUENCE_PAGE = "confluencePage";
    public static final String ACTION_KEY_ACTION = "action";
    public static final String ACTION_KEY_CONFLUENCE_PARENT = "confluenceParent";
    public static final JsonPointer ACTION_POINTER_CONFLUENCE_PAGE_TITLE = JsonPointer.create().append("confluencePage").append("title");
    public static final JsonPointer ACTION_POINTER_GENERATED_PAGE_TITLE = JsonPointer.create().append("generatedPage").append("title");
    public static final JsonPointer ACTION_POINTER_GENERATED_PAGE_TYPE = JsonPointer.create().append("generatedPage").append("type");
    public static final JsonPointer ACTION_POINTER_CONFLUENCE_PARENT_ID = JsonPointer.create().append("confluenceParent").append("id");
    public static final JsonPointer ACTION_POINTER_GENERATED_PAGE_PARENT_TITLE = JsonPointer.create().append("generatedPage").append("parentTitle");
    public static final String PAGE_KEY_STRUCTURE = "structure";
    public static final String PAGE_KEY_CONFLUENCE = "confluence";
    public static final String PAGE_KEY_GENERATED_PAGE = "generatedPage";
    public static final JsonPointer PAGE_POINTER_GENERATED_PAGE = JsonPointer.create().append("generatedPage");
    public static final JsonPointer PAGE_POINTER_CONFLUENCE = JsonPointer.create().append("confluence");
    public static final JsonPointer PAGE_POINTER_STRUCTURE_CHILDREN = JsonPointer.create().append("structure").append("children");
    public static final JsonPointer PAGE_POINTER_GENERATED_PAGE_TITLE = JsonPointer.create().append(PAGE_POINTER_GENERATED_PAGE).append("title");
    public static final JsonPointer PAGE_POINTER_CONFLUENCE_TITLE = JsonPointer.create().append(PAGE_POINTER_CONFLUENCE).append("title");
    public static final JsonPointer PAGE_POINTER_CONFLUENCE_CHILDREN = JsonPointer.create().append(PAGE_POINTER_CONFLUENCE).append("children");
    public static final JsonPointer PAGE_POINTER_GENERATED_PAGE_ON_DISK_PATH = JsonPointer.create().append(PAGE_POINTER_GENERATED_PAGE).append("onDiskPath");
    protected Logger LOGGER = LoggerFactory.getLogger(ConfluenceUploadPagesVerticle.class);
    private String release = null;
    private String uploadConfluencePages = null;
    @Resource
    @Nullable
    private ConfluenceClient confluenceClient;

    @Override
    protected String[] features() {
        return new String[]{"confluenceUpload"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        this.release = ConfigUtils.getConfigValue((String)"/release", (JsonObject)this.config());
        this.uploadConfluencePages = ConfigUtils.getConfigValue((String)"/confluence/uploadConfluencePages", (JsonObject)this.config());
        if (this.confluenceClient == null) {
            this.getLogger().warn("Offline mode. Exitting.");
            this.taskCompleted(taskPromise);
            return;
        }
        if (!this.uploadRequired(this.uploadConfluencePages)) {
            this.taskCompleted(taskPromise);
            return;
        }
        JsonArray generatedConfluencePages = this.graph.getVertex("root").getJsonArray("confluencePages");
        JsonObject confluenceStructure = null;
        try {
            confluenceStructure = JsonUtils.readJsonFile((String)FSUtils.getConfigFilePath((JsonObject)this.config(), (String[])new String[]{"config", "confluenceStructure.json"}));
        }
        catch (IOException e) {
            this.report.exceptionThrown(new JsonObject().put(PAGE_ID, (Object)"iTool"), (Exception)e);
        }
        JsonObject finalConfluenceStructure = confluenceStructure;
        String spaceKey = ConfigUtils.getConfigValue((String)"/confluence/space", (JsonObject)this.config());
        Future trashFuture = this.confluenceClient.getConfluencePageInfo(spaceKey, TRASH_PAGE_NAME);
        Future<JsonObject> existingTreeFuture = this.buildExistingConfluenceTree(spaceKey, finalConfluenceStructure);
        CompositeFuture.join((Future)trashFuture, existingTreeFuture).onComplete(res -> {
            JsonObject trashPage = (JsonObject)trashFuture.result();
            JsonObject realConfluenceTree = (JsonObject)existingTreeFuture.result();
            JsonArray actionsRequired = this.buildActions(realConfluenceTree, finalConfluenceStructure, generatedConfluencePages);
            this.logActions(actionsRequired);
            JsonArray mergedActions = this.mergeActions(actionsRequired);
            this.logActions(mergedActions);
            ArrayList actionFutures = new ArrayList();
            this.getLogger().info("Property {} is set to {}", (Object)"/confluence/uploadConfluencePages", (Object)this.uploadConfluencePages);
            List<JsonObject> createActions = mergedActions.stream().map(action -> (JsonObject)action).filter(action -> ACTION_CREATE.equals(action.getString(ACTION_KEY_ACTION))).collect(Collectors.toList());
            this.createPagesFromActions(createActions, spaceKey, trashPage).onComplete(result -> {
                mergedActions.stream().map(action -> (JsonObject)action).filter(action -> !ACTION_CREATE.equals(action.getString(ACTION_KEY_ACTION))).filter(action -> this.considerToPerformAction(this.uploadConfluencePages, (JsonObject)action)).forEach(action -> actionFutures.add(this.performAction(spaceKey, trashPage, (JsonObject)action)));
                this.completeCompositeTask(actionFutures, taskPromise);
            });
        });
    }

    private Future createPagesFromActions(List<JsonObject> createActions, String spaceKey, JsonObject trashPage) {
        LinkedList<JsonObject> queue = new LinkedList<JsonObject>();
        queue.addAll(createActions);
        LinkedList<JsonObject> parentedActions = new LinkedList<JsonObject>();
        LinkedList<JsonObject> orphanActions = new LinkedList<JsonObject>();
        while (!queue.isEmpty()) {
            JsonObject nextAction = (JsonObject)queue.remove();
            if (null != nextAction.getString(PAGE_PARENT_ID)) {
                parentedActions.add(nextAction);
                continue;
            }
            orphanActions.add(nextAction);
        }
        ArrayList actionFutures = new ArrayList();
        parentedActions.stream().filter(action -> this.considerToPerformAction(this.uploadConfluencePages, (JsonObject)action)).forEach(action -> actionFutures.add(this.performAction(spaceKey, trashPage, (JsonObject)action)));
        return CompositeFuture.join(actionFutures).compose(res -> {
            orphanActions.stream().forEach(orphanAction -> {
                actionFutures.stream().map(result -> (JsonObject)result.result()).forEach(result -> {
                    String newPageId = result.getString(PAGE_ID);
                    String orphanActionParentTitle = (String)ACTION_POINTER_GENERATED_PAGE_PARENT_TITLE.queryJson(orphanAction);
                    String newPageTitle = result.getString(PAGE_TITLE);
                    if (newPageTitle.equals(this.buildPageTitle(orphanActionParentTitle))) {
                        orphanAction.put(PAGE_PARENT_ID, (Object)newPageId);
                        this.getLogger().debug("'{}': New parent id set to {}", ACTION_POINTER_GENERATED_PAGE_TITLE.queryJson(orphanAction), (Object)newPageId);
                    }
                });
                if (orphanAction.getString(PAGE_PARENT_ID) == null) {
                    this.getLogger().debug("'{}': Still can not find parent ID", ACTION_POINTER_GENERATED_PAGE_TITLE.queryJson(orphanAction));
                }
            });
            if (orphanActions.isEmpty()) {
                return Future.succeededFuture();
            }
            return this.createPagesFromActions(orphanActions, spaceKey, trashPage);
        });
    }

    private void logActions(JsonArray actions) {
        if (this.getLogger().isDebugEnabled()) {
            String actionsString = actions.stream().map(actionObj -> {
                JsonObject action = (JsonObject)actionObj;
                return action.getString(ACTION_KEY_ACTION) + ":'" + action.getString(PAGE_TITLE) + "' (parentId=" + action.getString(PAGE_PARENT_ID) + ")";
            }).collect(Collectors.joining("; \n"));
            this.getLogger().debug("Actions list: \n{}", (Object)actionsString);
        }
    }

    private JsonArray mergeActions(JsonArray actionsNeeded) {
        Map<String, List<JsonObject>> groupedActions = actionsNeeded.stream().map(action -> (JsonObject)action).collect(Collectors.groupingBy(action -> action.getString(ACTION_KEY_ACTION)));
        if (!groupedActions.containsKey(ACTION_DELETE) || !groupedActions.containsKey(ACTION_CREATE)) {
            this.getLogger().debug("No changes required to confluence actions. Actions planned: {}", (Object)actionsNeeded.size());
            return actionsNeeded;
        }
        this.getLogger().debug("Planned actions before merge: {}", (Object)actionsNeeded.size());
        Collection<JsonObject> createActions = this.getActionsByType(groupedActions, ACTION_CREATE);
        Collection<JsonObject> deleteActions = this.getActionsByType(groupedActions, ACTION_DELETE);
        Iterator<JsonObject> createActionsIter = createActions.iterator();
        JsonArray mergedActions = new JsonArray();
        while (createActionsIter.hasNext()) {
            JsonObject createAction = createActionsIter.next();
            Iterator<JsonObject> deleteActionsIter = deleteActions.iterator();
            while (deleteActionsIter.hasNext()) {
                JsonObject deleteAction = deleteActionsIter.next();
                if (!createAction.getString(PAGE_TITLE).equals(deleteAction.getString(PAGE_TITLE))) continue;
                JsonObject mergedAction = new JsonObject().put(PAGE_TITLE, (Object)createAction.getString(PAGE_TITLE)).put(ACTION_KEY_CONFLUENCE_PAGE, (Object)deleteAction.getJsonObject(ACTION_KEY_CONFLUENCE_PAGE)).put("generatedPage", (Object)createAction.getJsonObject("generatedPage")).put(PAGE_PARENT_ID, (Object)createAction.getString(PAGE_PARENT_ID));
                if (null != ACTION_POINTER_GENERATED_PAGE_TYPE.queryJson((Object)createAction)) {
                    mergedAction.put(ACTION_KEY_ACTION, (Object)ACTION_UPDATE);
                } else {
                    mergedAction.put(ACTION_KEY_ACTION, (Object)ACTION_MOVE);
                }
                createActionsIter.remove();
                deleteActionsIter.remove();
                this.getLogger().debug("'{}': Actions merged into '{}'", (Object)mergedAction.getString(PAGE_TITLE), (Object)mergedAction.getString(ACTION_KEY_ACTION));
                mergedActions.add((Object)mergedAction);
            }
        }
        JsonArray resultingActions = new JsonArray(new ArrayList<JsonObject>(createActions));
        resultingActions.addAll(new JsonArray(new ArrayList<JsonObject>(deleteActions)));
        resultingActions.addAll(mergedActions);
        if (groupedActions.containsKey(ACTION_UPDATE)) {
            resultingActions.addAll(new JsonArray(groupedActions.get(ACTION_UPDATE)));
        }
        if (groupedActions.containsKey(ACTION_MOVE)) {
            resultingActions.addAll(new JsonArray(groupedActions.get(ACTION_MOVE)));
        }
        this.getLogger().debug("Planned actions after merge: {}", (Object)resultingActions.size());
        return resultingActions;
    }

    private Collection<JsonObject> getActionsByType(Map<String, List<JsonObject>> groupedActions, String actionName) {
        ArrayList duplicatedActions = new ArrayList();
        Collection<JsonObject> result = groupedActions.get(actionName).stream().collect(Collectors.toMap(action -> action.getString(PAGE_TITLE), action -> action, (firstAction, secondAction) -> {
            duplicatedActions.add(secondAction);
            return firstAction;
        })).values();
        if (duplicatedActions.size() > 0) {
            this.report.internalError("Found duplicated " + actionName + " actions for pages with title: " + duplicatedActions.stream().map(action -> action.getString(PAGE_TITLE)).distinct().collect(Collectors.joining(", ")));
        }
        return result;
    }

    private String getPageTitleFromAction(JsonObject action) {
        String pageTitle = this.buildPageTitle((String)ACTION_POINTER_GENERATED_PAGE_TITLE.queryJson((Object)action));
        if (pageTitle == null) {
            pageTitle = (String)ACTION_POINTER_CONFLUENCE_PAGE_TITLE.queryJson((Object)action);
        }
        return pageTitle;
    }

    private Future<JsonObject> performAction(String spaceKey, JsonObject trashPage, JsonObject action) {
        JsonObject generatedPage = action.getJsonObject("generatedPage");
        switch (action.getString(ACTION_KEY_ACTION)) {
            case "create": {
                if (generatedPage.containsKey(PAGE_ON_DISK_PATH)) {
                    return this.confluenceClient.updateConfluencePage(spaceKey, generatedPage.getString(PAGE_TITLE), generatedPage.getString(PAGE_PARENT_TITLE), generatedPage.getString(PAGE_ON_DISK_PATH), this.release);
                }
                return this.confluenceClient.createOrMoveConfluencePage(spaceKey, generatedPage.getString(PAGE_TITLE), action.getString(PAGE_PARENT_ID), this.release);
            }
            case "update": {
                return this.confluenceClient.updateConfluencePage(spaceKey, generatedPage.getString(PAGE_TITLE), generatedPage.getString(PAGE_PARENT_TITLE), generatedPage.getString(PAGE_ON_DISK_PATH), this.release);
            }
            case "delete": {
                return this.confluenceClient.moveConfluencePage(action.getJsonObject(ACTION_KEY_CONFLUENCE_PAGE), trashPage.getString(PAGE_ID), this.release);
            }
            case "move": {
                return this.confluenceClient.moveConfluencePage(action.getJsonObject(ACTION_KEY_CONFLUENCE_PAGE), action.getString(PAGE_PARENT_ID), this.release);
            }
        }
        return Future.failedFuture((String)"Unknown action");
    }

    protected boolean uploadRequired(String uploadConfluencePages) {
        if (uploadConfluencePages == null) {
            this.getLogger().warn("Parameter {} is not set, pages upload skipped", (Object)"/confluence/uploadConfluencePages");
            return false;
        }
        if ("none".equalsIgnoreCase(uploadConfluencePages)) {
            this.getLogger().warn("Parameter {} is set to 'none', pages upload skipped", (Object)"/confluence/uploadConfluencePages");
            return false;
        }
        return true;
    }

    protected boolean considerToPerformAction(String uploadConfluencePages, JsonObject action) {
        String uploadPages = uploadConfluencePages.toLowerCase(Locale.ROOT);
        if ("all".equalsIgnoreCase(uploadPages)) {
            return true;
        }
        String pageTitle = this.getPageTitleFromAction(action);
        String pageType = (String)ACTION_POINTER_GENERATED_PAGE_TYPE.queryJson((Object)action);
        if (this.isTitleMatches(pageTitle, uploadPages)) {
            return true;
        }
        if (uploadPages.contains("type")) {
            Matcher matcher = Pattern.compile("type:\\s*(\\w+)").matcher(uploadPages);
            while (matcher.find()) {
                if (!matcher.group(1).equalsIgnoreCase(pageType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTitleMatches(String pageTitle, String uploadPages) {
        String[] titles = uploadPages.split("\\s*,\\s*");
        return Arrays.stream(titles).anyMatch(title -> this.buildPageTitle((String)title).equalsIgnoreCase(pageTitle));
    }

    private JsonArray buildActions(JsonObject confluenceTree, JsonObject confluenceStructure, JsonArray generatedPages) {
        JsonArray actions = new JsonArray();
        LinkedList<JsonObject> queue = new LinkedList<JsonObject>();
        JsonObject nextLevel = new JsonObject().put(PAGE_KEY_CONFLUENCE, (Object)confluenceTree).put(PAGE_KEY_STRUCTURE, (Object)confluenceStructure);
        this.queueChildren(queue, nextLevel, generatedPages);
        while (!queue.isEmpty()) {
            JsonObject next = (JsonObject)queue.remove();
            if (this.getLogger().isDebugEnabled()) {
                String pageName = (String)PAGE_POINTER_CONFLUENCE_TITLE.queryJson((Object)next);
                if (pageName == null) {
                    pageName = (String)PAGE_POINTER_GENERATED_PAGE_TITLE.queryJson((Object)next);
                }
                this.getLogger().debug("'{}': Building actions.", (Object)pageName);
            }
            actions.addAll(this.generateNextActions(next));
            JsonArray children = (JsonArray)PAGE_POINTER_STRUCTURE_CHILDREN.queryJson((Object)next);
            if (children == null || children.isEmpty()) continue;
            this.queueChildren(queue, next, generatedPages);
        }
        return actions;
    }

    private JsonArray generateNextActions(JsonObject next) {
        JsonArray actions = new JsonArray();
        JsonObject action = new JsonObject();
        if (!next.containsKey(PAGE_KEY_CONFLUENCE)) {
            action.put(ACTION_KEY_ACTION, (Object)ACTION_CREATE).put("generatedPage", PAGE_POINTER_GENERATED_PAGE.queryJson((Object)next));
            this.getLogger().debug("'{}': Action {} was added to the list", PAGE_POINTER_GENERATED_PAGE_TITLE.queryJson((Object)next), (Object)ACTION_CREATE);
        } else if (!next.containsKey("generatedPage")) {
            action.put(ACTION_KEY_ACTION, (Object)ACTION_DELETE).put(ACTION_KEY_CONFLUENCE_PAGE, PAGE_POINTER_CONFLUENCE.queryJson((Object)next));
            this.getLogger().debug("'{}': Action {} was added to the list", PAGE_POINTER_CONFLUENCE_TITLE.queryJson((Object)next), (Object)ACTION_DELETE);
            if (((JsonObject)PAGE_POINTER_CONFLUENCE.queryJson((Object)next)).containsKey(STRUCT_CHILDREN)) {
                JsonArray children = (JsonArray)PAGE_POINTER_CONFLUENCE_CHILDREN.queryJson((Object)next);
                children.stream().map(child -> (JsonObject)child).forEach(child -> {
                    JsonObject nextChild = new JsonObject().put(ACTION_KEY_CONFLUENCE_PARENT, (Object)next.getJsonObject(PAGE_KEY_CONFLUENCE)).put(PAGE_KEY_CONFLUENCE, child);
                    actions.addAll(this.generateNextActions(nextChild));
                });
            }
        } else if (PAGE_POINTER_GENERATED_PAGE_ON_DISK_PATH.queryJson((Object)next) != null) {
            action.put(ACTION_KEY_ACTION, (Object)ACTION_UPDATE).put(ACTION_KEY_CONFLUENCE_PAGE, PAGE_POINTER_CONFLUENCE.queryJson((Object)next)).put("generatedPage", PAGE_POINTER_GENERATED_PAGE.queryJson((Object)next));
            this.getLogger().debug("'{}': Action {} was added to the list", PAGE_POINTER_CONFLUENCE_TITLE.queryJson((Object)next), (Object)ACTION_UPDATE);
        } else {
            this.getLogger().debug("'{}': No actions were added", PAGE_POINTER_CONFLUENCE_TITLE.queryJson((Object)next));
            return actions;
        }
        action.put(PAGE_PARENT_ID, ACTION_POINTER_CONFLUENCE_PARENT_ID.queryJson((Object)next));
        action.put(PAGE_TITLE, (Object)this.getPageTitleFromAction(action));
        actions.add((Object)action);
        return actions;
    }

    private void queueChildren(Queue<JsonObject> queue, JsonObject parent, JsonArray generatedConfluencePages) {
        JsonArray structureChildren = (JsonArray)PAGE_POINTER_STRUCTURE_CHILDREN.queryJson((Object)parent);
        JsonArray confluenceChildren = (JsonArray)PAGE_POINTER_CONFLUENCE_CHILDREN.queryJson((Object)parent);
        JsonArray remainingGeneratedConfluencePages = new JsonArray(generatedConfluencePages.getList());
        LinkedList<Object> remainingConfluenceChildren = new LinkedList<Object>();
        if (confluenceChildren != null) {
            remainingConfluenceChildren.addAll(confluenceChildren.getList());
        }
        this.queueTitledChildren(queue, parent, remainingConfluenceChildren, structureChildren);
        this.queueTypedChildren(queue, parent, remainingGeneratedConfluencePages, remainingConfluenceChildren, structureChildren);
    }

    private void queueTypedChildren(Queue<JsonObject> queue, JsonObject parent, JsonArray remainingGeneratedPages, List<Object> existingChildPages, JsonArray structChildren) {
        JsonObject existingParentPage = parent.getJsonObject(PAGE_KEY_CONFLUENCE);
        structChildren.stream().map(JsonObject.class::cast).filter(structChild -> structChild.containsKey("type")).forEach(structChild -> {
            if (!existingChildPages.isEmpty()) {
                Iterator existingChildPagesIterator = existingChildPages.iterator();
                while (existingChildPagesIterator.hasNext()) {
                    JsonObject existingChildPage = JsonObject.mapFrom(existingChildPagesIterator.next());
                    JsonObject matchedGeneratedPage = this.getGeneratedPage(remainingGeneratedPages, existingParentPage, existingChildPage, (JsonObject)structChild);
                    if (matchedGeneratedPage == null) continue;
                    JsonObject nextLevelChild = new JsonObject().put(PAGE_KEY_STRUCTURE, structChild).put(PAGE_KEY_CONFLUENCE, (Object)existingChildPage).put("generatedPage", (Object)matchedGeneratedPage).put(ACTION_KEY_CONFLUENCE_PARENT, (Object)existingParentPage);
                    queue.add(nextLevelChild);
                    remainingGeneratedPages.remove((Object)matchedGeneratedPage);
                    existingChildPagesIterator.remove();
                }
            }
            this.getGeneratedPagesForStructureSection(remainingGeneratedPages, (JsonObject)structChild, (String)PAGE_POINTER_GENERATED_PAGE_TITLE.queryJson((Object)parent)).stream().forEach(generatedPage -> {
                JsonObject nextLevelChild = new JsonObject();
                nextLevelChild.put(PAGE_KEY_STRUCTURE, structChild).put("generatedPage", generatedPage).put(ACTION_KEY_CONFLUENCE_PARENT, (Object)parent.getJsonObject(PAGE_KEY_CONFLUENCE));
                queue.add(nextLevelChild);
                remainingGeneratedPages.remove(generatedPage);
            });
        });
        if (!existingChildPages.isEmpty()) {
            existingChildPages.stream().map(JsonObject::mapFrom).forEach(confluenceChild -> {
                JsonObject nextLevelChild = new JsonObject();
                nextLevelChild.put(PAGE_KEY_CONFLUENCE, confluenceChild).put(ACTION_KEY_CONFLUENCE_PARENT, (Object)parent.getJsonObject(PAGE_KEY_CONFLUENCE));
                queue.add(nextLevelChild);
            });
        }
    }

    private void queueTitledChildren(Queue<JsonObject> queue, JsonObject parent, List<Object> remainingConfluenceChildren, JsonArray structChildren) {
        structChildren.stream().map(structChild -> (JsonObject)structChild).filter(structChild -> structChild.containsKey(PAGE_TITLE)).forEach(structChild -> {
            Iterator childIterator = remainingConfluenceChildren.iterator();
            Boolean confluencePageFound = false;
            while (childIterator.hasNext()) {
                JsonObject confluenceChild = JsonObject.mapFrom(childIterator.next());
                if (!confluenceChild.getString(PAGE_TITLE).equals(this.buildPageTitle(structChild.getString(PAGE_TITLE)))) continue;
                JsonObject nextLevelChild = new JsonObject().put(PAGE_KEY_STRUCTURE, structChild).put(PAGE_KEY_CONFLUENCE, (Object)confluenceChild).put("generatedPage", (Object)new JsonObject().put(PAGE_TITLE, (Object)structChild.getString(PAGE_TITLE))).put(ACTION_KEY_CONFLUENCE_PARENT, (Object)parent.getJsonObject(PAGE_KEY_CONFLUENCE));
                queue.add(nextLevelChild);
                childIterator.remove();
                confluencePageFound = true;
                break;
            }
            if (!confluencePageFound.booleanValue()) {
                JsonObject nextLevelChild = new JsonObject().put(PAGE_KEY_STRUCTURE, structChild).put("generatedPage", (Object)new JsonObject().put(PAGE_TITLE, (Object)structChild.getString(PAGE_TITLE)).put(PAGE_PARENT_TITLE, PAGE_POINTER_CONFLUENCE_TITLE.queryJson((Object)parent))).put(ACTION_KEY_CONFLUENCE_PARENT, (Object)parent.getJsonObject(PAGE_KEY_CONFLUENCE));
                queue.add(nextLevelChild);
            }
        });
    }

    private JsonObject getGeneratedPage(JsonArray generatedPages, JsonObject parent, JsonObject child, JsonObject structChild) {
        JsonObject eligiblePage = generatedPages.stream().filter(generatedPage -> this.isChildAGeneratedPage(parent, child, (JsonObject)generatedPage) && ((JsonObject)generatedPage).getString("type").equals(structChild.getString("type"))).findFirst().orElse(null);
        return eligiblePage;
    }

    private JsonArray getGeneratedPagesForStructureSection(JsonArray generatedPages, JsonObject structChild, String parentTitle) {
        List matchingPages = generatedPages.stream().filter(generatedPage -> ((JsonObject)generatedPage).getString("type").equals(structChild.getString("type")) && ((JsonObject)generatedPage).getString(PAGE_PARENT_TITLE).equals(parentTitle)).collect(Collectors.toList());
        return new JsonArray(matchingPages);
    }

    private boolean isChildAGeneratedPage(JsonObject parent, JsonObject child, JsonObject generatedPage) {
        return parent.getString(PAGE_TITLE).equals(this.buildPageTitle(generatedPage.getString(PAGE_PARENT_TITLE))) && child.getString(PAGE_TITLE).equals(this.buildPageTitle(generatedPage.getString(PAGE_TITLE)));
    }

    private Future<JsonObject> buildExistingConfluenceTree(String spaceKey, JsonObject confluenceStructure) {
        String rootPageTitle = confluenceStructure.getString(PAGE_TITLE);
        JsonArray firstLevelChildren = confluenceStructure.getJsonArray(STRUCT_CHILDREN);
        HashSet firstLvlTitles = new HashSet();
        firstLevelChildren.stream().forEach(child -> {
            JsonObject childJson = (JsonObject)child;
            firstLvlTitles.add(this.buildPageTitle(childJson.getString(PAGE_TITLE)));
        });
        Future confluenceTreeFuture = this.confluenceClient.getConfluencePageInfo(spaceKey, rootPageTitle).compose(rootPage -> {
            String rootId = rootPage.getString(PAGE_ID);
            return this.confluenceClient.getChildPages(spaceKey, rootId).compose(children -> {
                JsonArray childrenList = new JsonArray();
                children.stream().forEach(child -> {
                    if (firstLvlTitles.contains(((JsonObject)child).getString(PAGE_TITLE))) {
                        childrenList.add(child);
                    }
                });
                rootPage.put(STRUCT_CHILDREN, (Object)childrenList);
                return Future.succeededFuture((Object)rootPage);
            });
        }).compose(page -> {
            ArrayList childFutures = new ArrayList();
            JsonArray children = page.getJsonArray(STRUCT_CHILDREN);
            children.stream().forEach(childPage -> childFutures.add(this.addChildren((JsonObject)childPage, spaceKey)));
            return CompositeFuture.join(childFutures).compose(res -> Future.succeededFuture((Object)page));
        });
        return confluenceTreeFuture;
    }

    private String buildPageTitle(String title) {
        if (title == null) {
            return null;
        }
        return this.release == null ? title : this.release + " " + title;
    }

    private Future<JsonObject> addChildren(JsonObject page, String spaceKey) {
        this.getLogger().debug("Adding child pages for page {}", (Object)page.getString(PAGE_TITLE));
        return this.confluenceClient.getChildPages(spaceKey, page.getString(PAGE_ID)).compose(children -> {
            ArrayList childFutures = new ArrayList();
            page.put(STRUCT_CHILDREN, children);
            children.stream().forEach(childPage -> childFutures.add(this.addChildren((JsonObject)childPage, spaceKey)));
            return CompositeFuture.join(childFutures).compose(res -> Future.succeededFuture((Object)page));
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

