/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence.summary;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSummaryMicroservicesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceSummaryMicroservicesVerticle.class);

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        return null;
    }

    @Override
    protected List<ConfluencePage> prepareConfluencePageList() {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        ConfluencePage page = new ConfluencePage();
        confluencePageList.add(page);
        page.setTitle("Cloud Microservices list");
        page.setParentTitle("Summary");
        page.setType("summary");
        page.setTemplate("summary/microservicesList.ftlh");
        page.setDirectoryPath("summary/");
        page.setFileName("microservices");
        List microservicesList = this.graph.traversal().V(new String[]{"root"}).out(new String[0]).hasType(new String[]{"domain"}).as("D", new String[0]).out(new String[0]).not((Traversal)__.hasType((String[])new String[]{"library"})).has("isMicroservice", P.eq((Object)true)).as("C", new String[0]).local((Traversal)__.in((String[])new String[0]).where((Traversal)__.not((Traversal)__.hasType((String[])new String[]{"domain"}))).count()).as("T", new String[0]).local((Traversal)__.outE((String[])new String[]{"info"}).as("LU", new String[0]).inV().hasType(new String[]{"language"}).as("LV", new String[0]).select(new String[]{"LU", "LV"}).values(new String[]{"usages:/LU/usage", "id:/LV/id", "name:/LV/name", "version:/LV/version"}).fold()).as("L", new String[0]).select(new String[]{"D", "C", "T", "L"}).toList();
        for (Map microservice : microservicesList) {
            String framework;
            JsonObject component = (JsonObject)microservice.get("C");
            String languages = LanguageUtils.getLanguagesAsString((BasicGraph)this.graph, (JsonObject)component);
            if (!StringUtils.isEmpty((CharSequence)languages)) {
                microservice.put("language", languages);
            }
            if ((framework = (String)JsonPointer.from((String)"/details/framework").queryJson((Object)component)) != null && !framework.isEmpty()) {
                List<String> frameworks = Arrays.asList(framework.split("\\s*,\\s*"));
                microservice.put("framework", String.join((CharSequence)", ", TechNormalizationHelper.normalizeTechs(frameworks)));
            }
            List versions = JsonUtils.asList(microservice.get("L"));
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList<String> targets = new ArrayList<String>();
            for (Object languageVersion : versions) {
                Map versionDetails = JsonUtils.asMap(languageVersion);
                List languageUsages = JsonUtils.asList(versionDetails.get("usages"));
                if (languageUsages == null) continue;
                ConfluenceSummaryMicroservicesVerticle.updateUsages(versionDetails, languageUsages, sources, "source");
                ConfluenceSummaryMicroservicesVerticle.updateUsages(versionDetails, languageUsages, targets, "target");
            }
            JsonObject versionsList = new JsonObject();
            versionsList.put("source", (Object)String.join((CharSequence)", ", sources));
            versionsList.put("target", (Object)String.join((CharSequence)", ", targets));
            microservice.remove("L");
            microservice.put("version", versionsList);
        }
        page.addDataModel("microservicesList", (Object)microservicesList);
        return confluencePageList;
    }

    private static void updateUsages(Map<String, String> languageVersion, List<String> languageUsages, List<String> usageContainer, String usage) {
        String version;
        if (languageUsages.contains(usage) && (version = languageVersion.get("version")) != null) {
            usageContainer.add(version);
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

