/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence.summary;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSummaryTechStacksPerDomainVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceSummaryTechStacksPerDomainVerticle.class);

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        return null;
    }

    @Override
    protected List<ConfluencePage> prepareConfluencePageList() {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        ConfluencePage page = new ConfluencePage();
        confluencePageList.add(page);
        page.setTitle("Cloud Tech. stack per Domain");
        page.setParentTitle("Summary");
        page.setType("summary");
        page.setTemplate("summary/techStacksPerDomain.ftlh");
        page.setDirectoryPath("summary/");
        page.setFileName("techStacksPerDomain");
        ArrayList<JsonObject> techStacks = new ArrayList<JsonObject>();
        Map techs = (Map)this.V(new String[0]).hasType(new String[]{"domain"}).as("D", new String[0]).out(new String[0]).bothE(new String[0]).as("E", new String[0]).inV().where((Traversal)__.in((String[])new String[0]).hasId(new String[]{"Infra", "Info"})).not((Traversal)__.has((String)"type", (String)"gateway")).name().as("T", new String[0]).select(new String[]{"T", "D", "E"}).values(new String[]{"domain:/D/id", "usedTech:/T", "type:/E/type"}).dedup().group().by("domain").next();
        for (Map.Entry domain : techs.entrySet()) {
            JsonArray unknownTechs = new JsonArray();
            JsonObject techJson = new JsonObject();
            for (Object tech : (List)domain.getValue()) {
                Map techMap = JsonUtils.asMap(tech);
                String usedTech = (String)techMap.get("usedTech");
                Optional matchedTechKey = TechNormalizationHelper.normalizeTech((String)usedTech);
                if (matchedTechKey.isPresent()) {
                    techJson.put((String)matchedTechKey.get(), (Object)this.toNecessityValue((String)techMap.get("type")));
                    continue;
                }
                unknownTechs.add((Object)usedTech);
            }
            techStacks.add(new JsonObject().put("domain", domain.getKey()).put("techsList", (Object)techJson).put("unknownTechs", (Object)(unknownTechs.isEmpty() ? null : unknownTechs)));
        }
        page.addDataModel("techStacks", techStacks);
        page.addDataModel("techNames", TechNormalizationHelper.getTechNamesMap().keySet());
        return confluencePageList;
    }

    private String toNecessityValue(String type) {
        if (type == null) {
            return "Unknown";
        }
        if ("optional".equalsIgnoreCase(type)) {
            return "O";
        }
        return "M";
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

