/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.dependency;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDataConstants;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetEdgesBetweenComponentsVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(SetEdgesBetweenComponentsVerticle.class);
    public static final String INFRA_VERTEX_ID = "Infra";
    private static final JsonPointer DNS_NAME_PTR = JsonPointer.from((String)"/details/dnsName");

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        ArrayList<JsonObject> components = new ArrayList<JsonObject>();
        List domains = this.V("root").out(new String[0]).hasType(new String[]{"domain"}).toList();
        for (JsonObject domain : domains) {
            components.addAll(SetEdgesBetweenComponentsVerticle.getComponents(this.graph, domain));
        }
        Map componentFrameworks = (Map)this.V(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).as("C", new String[0]).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", P.eq((Object)__.select((String)"C").id())).inV().or(new Traversal[]{__.has((String)"groupId", (P)P.eq((Object)"org.springframework.boot")), __.has((String)"groupId", (P)P.eq((Object)"io.quarkus"))}).as("F", new String[0]).select(new String[]{"C", "F"}).values(new String[]{"/C/id", "/F/groupId", "/F/version"}).dedup().group().by("id").next();
        this.vertx.executeBlocking(promise -> {
            for (JsonObject component : components) {
                String componentId = component.getString("id");
                this.getLogger().debug("{}: Set outgoing Edges", (Object)componentId);
                try {
                    this.setEdgesToInfraVertexes(component);
                    this.processDatabases(component);
                    this.processMessagesQueues(component);
                    this.processDependencies(component);
                    LanguageUtils.buildLanguageVerticesWithEdges((Graph)this.graph, (JsonObject)component);
                    if (componentFrameworks.containsKey(componentId)) {
                        List frameworks = (List)componentFrameworks.get(componentId);
                        this.processDetailsProperty(component, frameworks, "framework", "info");
                    } else {
                        this.processDetailsProperty(component, "framework", "info");
                    }
                    this.processDetailsProperty(component, "tmfSpec", "implemented");
                    this.processGateways(component, "info");
                }
                catch (Exception ex) {
                    this.report.exceptionThrown(component, ex);
                }
            }
            Map librariesArtifacts = (Map)this.V("root").out(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).id().as("L", new String[0]).out(new String[]{"module"}).value("artifactId").as("A", new String[0]).select(new String[]{"L", "A"}).group().by("A").by("L").next();
            for (JsonObject component : components) {
                try {
                    this.processLanguageArtifactDependencies(component, librariesArtifacts);
                }
                catch (Exception ex) {
                    this.report.exceptionThrown(component, ex);
                }
            }
            promise.complete();
        }, res -> this.taskCompleted(taskPromise));
    }

    private void processLanguageArtifactDependencies(JsonObject component, Map<String, List<String>> librariesArtifacts) {
        if (LanguageUtils.hasLanguage((BasicGraph)this.graph, (JsonObject)component, (String)"GoLang")) {
            this.processGoDependencies(component, librariesArtifacts);
        } else {
            this.processMavenDependencies(component, librariesArtifacts);
        }
    }

    private void setEdgesToInfraVertexes(JsonObject component) {
        String componentId = component.getString("id");
        ArrayList dependencies = new ArrayList();
        Graph graph = this.graph;
        GraphTraversal directTraversal = SetEdgesBetweenComponentsVerticle.V(graph, componentId).as("C", new String[0]).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", P.eq((Object)__.select((String)"C").id())).inV().dedup();
        dependencies.addAll(directTraversal.clone().toList());
        List transitiveDependencies = directTraversal.clone().outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).inV().dedup().repeat((Traversal)__.outE((String[])new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", P.eq((Object)__.select((String)"C").id())).inV().dedup()).emit().dedup().toList();
        dependencies.addAll(transitiveDependencies);
        List infraVertexes = this.V(INFRA_VERTEX_ID).out(new String[0]).toList();
        for (JsonObject vertex : infraVertexes) {
            JsonArray drivers = vertex.getJsonArray("drivers");
            if (drivers == null || drivers.isEmpty()) continue;
            for (Object tmp : drivers) {
                JsonObject driver = (JsonObject)tmp;
                String driverGroupId = driver.getString("groupId");
                String driverArtifactId = driver.getString("artifactId");
                for (JsonObject dependency : dependencies) {
                    String dependencyGroupId = dependency.getString("groupId");
                    String dependencyArtifactId = dependency.getString("artifactId");
                    if (driverGroupId == null || !driverGroupId.equals(dependencyGroupId) || driverArtifactId == null || !driverArtifactId.equals(dependencyArtifactId)) continue;
                    graph.addEdge(component, vertex, new JsonObject().put("type", (Object)"fromDependency").put("thirdParty", (Object)vertex.getString("id")).put("component", JsonPointer.from((String)"/details/abbreviation").queryJson((Object)component)));
                }
            }
        }
    }

    private void processMavenDependencies(JsonObject component, Map<String, List<String>> librariesArtifacts) {
        String componentId = component.getString("id");
        Graph graph = this.graph;
        GraphTraversal directTraversal = SetEdgesBetweenComponentsVerticle.V(graph, componentId).as("C", new String[0]).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", P.eq((Object)__.select((String)"C").id())).inV().dedup();
        List directDependencies = directTraversal.clone().value("artifactId").toList();
        List transitiveDependencies = directTraversal.clone().outE(new String[]{"dependency"}).has("scope", P.neq((Object)"test")).inV().dedup().repeat((Traversal)__.outE((String[])new String[]{"dependency"}).has("scope", P.neq((Object)"test")).has("component", P.eq((Object)__.select((String)"C").id())).inV().dedup()).emit().dedup().value("artifactId").toList();
        HashSet<String> refSet = new HashSet<String>();
        this.getLogger().debug("{}: Processing direct maven dependencies", (Object)componentId);
        this.extractDependency(librariesArtifacts, directDependencies, refSet);
        this.getLogger().debug("{}: Processing transitive maven dependencies", (Object)componentId);
        this.extractDependency(librariesArtifacts, transitiveDependencies, refSet);
        for (String libraryId : refSet) {
            if (componentId.equals(libraryId)) continue;
            graph.addEdge(component, graph.getVertex(libraryId), new JsonObject().put("type", (Object)"library"));
        }
    }

    private void processGoDependencies(JsonObject component, Map<String, List<String>> librariesArtifacts) {
        String componentId = component.getString("id");
        List dependencies = this.V(componentId).as("C", new String[0]).out(new String[]{"module"}).outE(new String[]{"dependency"}).has("component", P.eq((Object)__.select((String)"C").id())).inV().dedup().value("artifactId").toList();
        HashSet<String> refSet = new HashSet<String>();
        this.extractDependency(librariesArtifacts, dependencies, refSet);
        for (String libraryId : refSet) {
            if (componentId.equals(libraryId)) continue;
            this.graph.addEdge(component, this.graph.getVertex(libraryId), new JsonObject().put("type", (Object)"library"));
        }
    }

    private void extractDependency(Map<String, List<String>> librariesArtifacts, List<String> dependencies, Set<String> refSet) {
        for (String artifactId : dependencies) {
            List<String> libraryIds = librariesArtifacts.get(artifactId);
            if (libraryIds == null || libraryIds.isEmpty()) continue;
            refSet.add(libraryIds.get(0));
        }
    }

    private void processDetailsProperty(JsonObject component, List<Map> frameworks, String detailsType, String edgeType) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map framework : frameworks) {
            String name = "Unknown";
            if ("org.springframework.boot".equals(framework.get("groupId"))) {
                name = "SpringBoot";
            }
            if ("io.quarkus".equals(framework.get("groupId"))) {
                name = "Quarkus";
            }
            String version = (String)framework.get("version");
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(name).append(" ").append(version);
            isFirst = false;
        }
        component.getJsonObject("details").put(detailsType, (Object)builder.toString());
        this.processDetailsProperty(component, detailsType, edgeType);
    }

    private void processDetailsProperty(JsonObject component, String detailsType, String edgeType) {
        List detailsProperties;
        Object detailsProperty = JsonPointer.from((String)"/details").append(detailsType).queryJson((Object)component);
        if (detailsProperty == null) {
            return;
        }
        if (detailsProperty instanceof String) {
            detailsProperties = Arrays.asList(((String)detailsProperty).split("\\s*,\\s*"));
        } else if (detailsProperty instanceof JsonArray) {
            detailsProperties = ((JsonArray)detailsProperty).getList();
        } else {
            this.report.conventionNotMatched(component, "/details/" + detailsType + ": must be String or JsonArray", detailsProperty.getClass().getName());
            return;
        }
        Graph graph = this.graph;
        detailsProperties.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p) && !GraphDataConstants.NOS_TO_RECOGNIZE.contains(p)).forEach(p -> {
            JsonObject propertyVertex = graph.getVertex(p);
            if (propertyVertex == null) {
                propertyVertex = new JsonObject().put("id", p).put("name", p).put("type", (Object)detailsType);
                graph.addVertex("Info", propertyVertex);
            } else if (!propertyVertex.getString("type").equals(detailsType)) {
                this.report.addMessage("CONF_ERROR", propertyVertex, "Reference duplicated. Types: [" + detailsType + ", " + propertyVertex.getString("type") + "]");
            }
            graph.addEdge(component, propertyVertex, new JsonObject().put("type", (Object)edgeType));
        });
    }

    private void processGateways(JsonObject component, String edgeType) {
        JsonArray gatewaysList;
        HashSet<String> gateways = new HashSet<String>();
        Graph graph = this.graph;
        JsonObject deployOptions = (JsonObject)JsonPointer.from((String)"/details/deploymentConfiguration/deployOptions").queryJson((Object)component);
        if (deployOptions != null) {
            if (!deployOptions.getString("generateFacadeGateway", "false").equals("false")) {
                gateways.add("FACADE");
            }
            if (deployOptions.containsKey("generateNamedGateway")) {
                gateways.add("COMPOSITE");
            }
        }
        if ((gatewaysList = (JsonArray)JsonPointer.from((String)"/details/gateways").queryJson((Object)component)) != null && !gatewaysList.isEmpty()) {
            gateways.addAll(gatewaysList.getList());
        }
        if (gateways.isEmpty()) {
            return;
        }
        String type = "gateway";
        gateways.stream().filter(g -> StringUtils.isNotBlank((CharSequence)g) && !GraphDataConstants.NOS_TO_RECOGNIZE.contains(g)).map(g -> g.toUpperCase()).forEach(g -> {
            JsonObject propertyVertex = graph.getVertex(g);
            if (propertyVertex == null) {
                propertyVertex = new JsonObject().put("id", g).put("name", g).put("type", (Object)type);
                graph.addVertex("Info", propertyVertex);
            }
            graph.addEdge(component, propertyVertex, new JsonObject().put("type", (Object)edgeType));
        });
    }

    private void processDatabases(JsonObject component) {
        JsonArray databaseList = JsonUtils.getOrCreateJsonArray((JsonObject)component, (JsonPointer)JsonPointer.from((String)"/details/database/database"));
        if (databaseList.isEmpty()) {
            return;
        }
        for (Object tmp : databaseList) {
            this.createDatabaseEdge(component, (JsonObject)tmp, "database", "mandatory");
        }
        JsonObject externalIndices = (JsonObject)JsonPointer.from((String)"/details/database/externalIndices").queryJson((Object)component);
        this.createDatabaseEdge(component, externalIndices, "indexation", "mandatory");
        JsonObject externalCache = (JsonObject)JsonPointer.from((String)"/details/database/externalCache").queryJson((Object)component);
        this.createDatabaseEdge(component, externalCache, "caching", "optional");
    }

    private String normalizeThirdpartyName(String value, String vertexType) {
        String name = value.split("\\s+")[0];
        List dbList = this.V(INFRA_VERTEX_ID).out(new String[0]).hasType(new String[]{vertexType}).toList();
        for (JsonObject item : dbList) {
            String thirdpartyName = item.getString("name");
            if (!name.equalsIgnoreCase(thirdpartyName)) continue;
            return thirdpartyName;
        }
        return value;
    }

    private void createDatabaseEdge(JsonObject sourceComponent, JsonObject detailsJson, String vertexType, String edgeType) {
        if (detailsJson == null) {
            return;
        }
        String databaseName = detailsJson.getString("item");
        if (StringUtils.isEmpty((CharSequence)databaseName) || GraphDataConstants.NOS_TO_RECOGNIZE.contains(databaseName.toLowerCase())) {
            return;
        }
        Graph graph = this.graph;
        JsonObject dbVertex = graph.getVertex(databaseName = this.normalizeThirdpartyName(databaseName, vertexType));
        if (dbVertex == null) {
            dbVertex = new JsonObject();
            dbVertex.put("id", (Object)databaseName);
            dbVertex.put("name", (Object)databaseName);
            dbVertex.put("type", (Object)vertexType);
            dbVertex.put("fromInventory", (Object)true);
            graph.addVertex(INFRA_VERTEX_ID, dbVertex);
        }
        graph.addEdge(sourceComponent, dbVertex, new JsonObject().put("type", (Object)edgeType));
    }

    private void processMessagesQueues(JsonObject component) {
        JsonObject messageQueues = (JsonObject)JsonPointer.from((String)"/details/messageQueues").queryJson((Object)component);
        if (messageQueues == null) {
            return;
        }
        JsonArray rabbitMQProducer = (JsonArray)JsonPointer.from((String)"/details/messageQueues/rabbitMQ/producer").queryJson((Object)component);
        JsonArray rabbitMQConsumer = (JsonArray)JsonPointer.from((String)"/details/messageQueues/rabbitMQ/consumer").queryJson((Object)component);
        Graph graph = this.graph;
        JsonObject rabbitMQComponent = graph.getVertex("RabbitMQ");
        this.createMessageQueueEdge(graph, component, rabbitMQComponent, rabbitMQProducer, "producer");
        this.createMessageQueueEdge(graph, rabbitMQComponent, component, rabbitMQConsumer, "consumer");
        JsonArray kafkaProducer = (JsonArray)JsonPointer.from((String)"/details/messageQueues/kafka/producer").queryJson((Object)component);
        JsonArray kafkaConsumer = (JsonArray)JsonPointer.from((String)"/details/messageQueues/kafka/consumer").queryJson((Object)component);
        JsonObject kafkaComponent = graph.getVertex("Kafka");
        this.createMessageQueueEdge(graph, component, kafkaComponent, kafkaProducer, "producer");
        this.createMessageQueueEdge(graph, kafkaComponent, component, kafkaConsumer, "consumer");
    }

    private void createMessageQueueEdge(Graph graph, JsonObject sourceComponent, JsonObject mqComponent, JsonArray list, String type) {
        if (mqComponent == null || list == null) {
            return;
        }
        for (Object exchangeName : list) {
            if (GraphDataConstants.NOS_TO_RECOGNIZE.contains(exchangeName.toString().toLowerCase())) continue;
            graph.addEdge(sourceComponent, mqComponent, new JsonObject().put("type", (Object)type).put("name", exchangeName));
        }
    }

    private void processDependencies(JsonObject component) {
        this.getLogger().debug("{}: Processing http dependencies", (Object)component.getString("id"));
        JsonObject dependencies = (JsonObject)JsonPointer.from((String)"/details/dependencies").queryJson((Object)component);
        if (dependencies == null) {
            this.getLogger().debug("Dependencies are null for {}", (Object)component.getString("id"));
            return;
        }
        GraphDataConstants.COMP_DEPENDENCY_TYPES.forEach((key, value) -> this.createDependencyEdge(component, (JsonArray)JsonPointer.from((String)value).queryJson((Object)component), (String)key));
    }

    private void createDependencyEdge(JsonObject sourceComponent, JsonArray dependencies, String type) {
        if (dependencies == null) {
            return;
        }
        for (Object tmp : dependencies) {
            JsonObject destinationComponent;
            String dependency = (String)tmp;
            if (GraphDataConstants.NOS_TO_RECOGNIZE.contains(dependency.toLowerCase())) continue;
            List destinationComponents = this.V("root").out(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).or(new Traversal[]{__.has((String)"isMock", (P)P.neq((Object)true)).has("/details/dnsNames", P.containing((Object)dependency)), __.has((String)"isMock", (P)P.eq((Object)true)).has("/details/dnsNames", P.eq((Object)dependency))}).toList();
            String edgeType = null;
            if (destinationComponents.isEmpty()) {
                destinationComponent = this.createMockByDnsName(dependency);
                this.graph.addVertex(destinationComponent);
                edgeType = SetEdgesBetweenComponentsVerticle.getEdgeType(type, sourceComponent, destinationComponent);
                this.report.referenceNotFound(sourceComponent, edgeType + " http dependency " + dependency);
            } else if (destinationComponents.size() == 1) {
                destinationComponent = (JsonObject)destinationComponents.get(0);
            } else {
                destinationComponent = (JsonObject)destinationComponents.get(0);
                JsonObject another = (JsonObject)destinationComponents.get(1);
                this.report.addMessage("CONF_ERROR", destinationComponent, "Vertices '" + destinationComponent.getString("id") + "' and '" + another.getString("id") + "' share the same dnsName '" + dependency + "'");
            }
            if (edgeType == null) {
                edgeType = SetEdgesBetweenComponentsVerticle.getEdgeType(type, sourceComponent, destinationComponent);
            }
            this.graph.addEdge(sourceComponent, destinationComponent, new JsonObject().put("type", (Object)edgeType).put("protocol", (Object)"http"));
        }
    }

    private JsonObject createMockByDnsName(String dnsName) {
        String mockId = "mock:dnsName:" + dnsName;
        this.getLogger().info("Mock vertex {} created to substitute dnsName {}", (Object)mockId, (Object)dnsName);
        return new JsonObject().put("id", (Object)mockId).put("type", (Object)"unknown").put("name", (Object)dnsName).put("isMock", (Object)true).put("mockedFor", (Object)new JsonArray().add((Object)"/details/dnsNames")).put("details", (Object)new JsonObject().put("dnsName", (Object)dnsName).put("dnsNames", (Object)dnsName));
    }

    private static String getEdgeType(String type, JsonObject sourceComponent, JsonObject destinationComponent) {
        if (SetEdgesBetweenComponentsVerticle.isGqls(destinationComponent) || "optional".equals(type) && SetEdgesBetweenComponentsVerticle.isGqls(sourceComponent)) {
            return "graphql";
        }
        return type;
    }

    private static boolean isGqls(JsonObject comp) {
        return "GQLS".equals(comp.getString("id")) || "cloud-graphql".equals(DNS_NAME_PTR.queryJson((Object)comp));
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

