/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.init;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInitializeDomainsVerticle
extends FlowTask {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractInitializeDomainsVerticle.class);
    private static final String F_COMPONENTS = "components";

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        List<Path> domainConfigs;
        JsonArray includeDomains = this.getIncludedDomains();
        try (Stream<Path> walk = Files.walk(Paths.get(FSUtils.getConfigFilePath((JsonObject)this.config(), (String[])new String[]{"config", "domains"}), new String[0]), new FileVisitOption[0]);){
            domainConfigs = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".json") && this.containsIn((Path)f, includeDomains)).collect(Collectors.toList());
            this.getLogger().debug("Files discovered {}", domainConfigs);
        }
        catch (IOException e) {
            this.report.exceptionThrown(new JsonObject(), (Exception)e);
            domainConfigs = Collections.emptyList();
        }
        for (Path path : domainConfigs) {
            try {
                JsonObject domain = JsonUtils.readJsonFile((String)path.toString());
                LOG.info("Add Domain " + domain.getString("name") + " (" + domain.getString("id") + ")");
                this.addDomainToGraph(domain);
            }
            catch (IOException e) {
                this.getLogger().error("Failed to read " + String.valueOf(path));
            }
        }
        this.taskCompleted(taskPromise);
    }

    protected abstract boolean loadComponents();

    protected JsonArray getIncludedDomains() {
        String includeDomains = this.config().getString("includeDomains");
        JsonArray result = new JsonArray();
        if (includeDomains != null) {
            result = new JsonArray(new ArrayList<String>(Arrays.asList(includeDomains.split(",\\s*"))));
        }
        return result;
    }

    protected boolean containsIn(Path f, JsonArray includeDomains) {
        if (includeDomains.isEmpty()) {
            return true;
        }
        String fileName = f.getFileName().toString();
        return fileName.startsWith("internal_") && fileName.endsWith("_domain.json") || includeDomains.stream().anyMatch(domain -> fileName.contains(domain.toString() + "_domain.json"));
    }

    private void addDomainToGraph(JsonObject domain) {
        Graph graph;
        if (Boolean.valueOf(domain.getString("deprecated")).booleanValue()) {
            this.getLogger().warn("Skipping deprecated domain {}", (Object)domain.getString("id"));
            return;
        }
        String domainId = domain.getString("id");
        if ("domain".equals(domain.getString("type"))) {
            domainId = ConfigUtils.fillDomainId((String)domainId);
            domain.put("id", (Object)domainId);
        }
        if (!(graph = this.graph).addVertexUnderRoot(domain)) {
            this.report.componentDuplicated(graph.getVertex(domainId), domain);
        }
        List<JsonObject> components = this.extractDomainComponents(domain);
        domain.remove(F_COMPONENTS);
        for (JsonObject component : components) {
            Boolean deprecated = Boolean.valueOf(component.getString("deprecated"));
            if (deprecated.booleanValue()) {
                this.getLogger().warn("Skipping deprecated component {}", (Object)component.getString("id"));
                continue;
            }
            JsonPointer.from((String)"/details/domain").writeJson((Object)component, (Object)domainId, true);
            if (!graph.addVertex(domain, component)) {
                this.report.componentDuplicated(graph.getVertex(component.getString("id")), component);
            }
            JsonPointer.from((String)"/details/releaseBranch").writeJson((Object)component, (Object)this.decideReleaseBranch(component, domain), true);
        }
    }

    private String decideReleaseBranch(JsonObject c, JsonObject domain) {
        String configValue = ConfigUtils.getConfigValue((String)"/git/releaseBranch", (JsonObject)this.config());
        String domainOverrideValue = ConfigUtils.getConfigValue((String)"/releaseBranch", (JsonObject)domain);
        String componentOverrideValue = ConfigUtils.getConfigValue((String)"/releaseBranch", (JsonObject)c);
        if (domainOverrideValue != null) {
            configValue = domainOverrideValue;
        }
        if (componentOverrideValue != null) {
            configValue = componentOverrideValue;
        }
        return configValue;
    }

    protected List<JsonObject> extractDomainComponents(JsonObject domain) {
        if (!this.loadComponents()) {
            return Collections.emptyList();
        }
        ArrayList<JsonObject> components = new ArrayList<JsonObject>();
        if (domain.getJsonArray(F_COMPONENTS) != null) {
            for (Object c : domain.getJsonArray(F_COMPONENTS)) {
                components.add((JsonObject)c);
            }
        }
        return components;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

