/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.init;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDataConstants;
import org.qubership.itool.tasks.FlowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSpecificationVertexVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(AddSpecificationVertexVerticle.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        JsonObject vertex = this.graph.getVertex("Spec");
        JsonObject tmfSpecMapping = vertex.getJsonObject("tmf");
        tmfSpecMapping = tmfSpecMapping == null ? new JsonObject() : tmfSpecMapping;
        this.processDetailsProperty(vertex, tmfSpecMapping, "tmfSpec", "tmf");
        this.taskCompleted(taskPromise);
    }

    protected void processDetailsProperty(JsonObject vertex, JsonObject tmfSpecMapping, String detailsType, String vertexType) {
        List propertyList = this.V(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).value("/details/" + detailsType).dedup().toList();
        ArrayList<String> property = new ArrayList<String>();
        for (Object prop : propertyList) {
            if (prop instanceof String) {
                property.add((String)prop);
                continue;
            }
            if (prop instanceof JsonArray) {
                List tmpList = ((JsonArray)prop).getList();
                for (Object tmp : tmpList) {
                    if (tmp instanceof String) {
                        property.add((String)tmp);
                        continue;
                    }
                    this.report.conventionNotMatched(vertex, "String", tmp.getClass().getName());
                }
                continue;
            }
            this.report.conventionNotMatched(vertex, "String, JsonArray", prop.getClass().getName());
        }
        property.stream().filter(p -> !GraphDataConstants.NOS_TO_RECOGNIZE.contains(p)).flatMap(p -> Arrays.stream(p.split("\\s*,\\s*"))).forEach(p -> this.createIfRequired(vertex, tmfSpecMapping, (String)p, vertexType, (String)p));
    }

    protected void createIfRequired(JsonObject vertex, JsonObject tmfSpecMapping, String id, String type, String name) {
        Graph graph = this.graph;
        String vId = id.replaceAll("(\\d+)\\s*v?\\S*", "$1");
        JsonObject component = graph.getVertex(vId);
        if (component != null) {
            return;
        }
        String specName = (String)JsonPointer.from((String)("/" + id + "/name")).queryJson((Object)tmfSpecMapping);
        String specUrl = (String)JsonPointer.from((String)("/" + id + "/url")).queryJson((Object)tmfSpecMapping);
        String specVersion = (String)JsonPointer.from((String)("/" + id + "/version")).queryJson((Object)tmfSpecMapping);
        Integer specCode = (Integer)JsonPointer.from((String)("/" + id + "/code")).queryJson((Object)tmfSpecMapping);
        component = new JsonObject().put("id", (Object)vId).put("type", (Object)type).put("name", (Object)(specName != null ? specName : name)).put("url", (Object)(specUrl == null ? this.generateUrlFromId(id) : specUrl)).put("version", (Object)specVersion).put("code", specCode != null ? specCode : vId);
        graph.addVertex(vertex, component);
        this.getLogger().info("Specification component added: " + String.valueOf(component));
    }

    private String generateUrlFromId(String id) {
        return "https://www.tmforum.org/resources/?yith_wcan=1&s=" + id + "&post_type=product&filter_document-type=specifications";
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

