/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.init;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.cli.config.ConfigProvider;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryToolInitVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(InventoryToolInitVerticle.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        this.getLogger().debug("Initializing the tool for a flow. Graph instance is: Graph @{}", (Object)System.identityHashCode(this.graph));
        ConfigUtils.getFilesFromJsonConfig((Vertx)this.vertx, (JsonObject)this.config(), (JsonPointer)JsonPointer.from((String)"/files"), (String[])new String[]{"config", "cleanupConfig.json"}).compose(files -> {
            List futures = files.stream().map(f -> this.vertx.fileSystem().deleteRecursive(f.toString(), true).recover(e -> this.reportDeleteFailure((Throwable)e, (Path)f))).collect(Collectors.toList());
            return CompositeFuture.join(futures);
        }).compose(r -> this.saveConfigFuture()).onComplete(r -> this.taskCompleted(taskPromise));
    }

    private Future<Void> reportDeleteFailure(Throwable e, Path f) {
        if (e instanceof FileSystemException && e.getCause() instanceof NoSuchFileException) {
            this.getLogger().info("Failed to delete {} : file not found", (Object)f);
        } else {
            this.report.internalError("Failed to delete " + String.valueOf(f) + " : " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return Future.succeededFuture();
    }

    private Future<Object> saveConfigFuture() {
        return Future.future(promise -> {
            JsonObject effectiveConfig = new JsonObject(new HashMap(this.config().getMap()));
            ConfigProvider.HIDDEN_PROPERTIES.forEach(pr -> effectiveConfig.getMap().replace(pr, "*****"));
            this.getLogger().info("Effective config: {}", (Object)effectiveConfig);
            try {
                Path eConfigPath = Path.of("output", "effectiveConfig.json");
                if (!eConfigPath.getParent().toFile().exists()) {
                    eConfigPath.getParent().toFile().mkdirs();
                }
                JsonUtils.saveJson((Path)eConfigPath, (Object)effectiveConfig, (boolean)false);
            }
            catch (IOException e) {
                promise.fail("Couldn't save effective config: " + ExceptionUtils.getStackTrace((Throwable)e));
            }
            promise.complete();
        }).onFailure(e -> this.report.internalError(e.getMessage()));
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

