/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.obfuscate;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObfuscationRulesVerticle
extends FlowTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ObfuscationRulesVerticle.class);
    protected Map<String, Trie<String, Boolean>> prefixesByType = new HashMap<String, Trie<String, Boolean>>();
    protected static final String[] processByTypes = new String[]{"root", "domain", "errorCode", "module", "library", "database", "indexation", "caching", "mq", "framework", "language", "tmf", "file", "directory", "gateway"};
    protected static final String[] alwaysPreserve = new String[]{"/id/", "/type/", "/name/", "/isMock/"};

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        JsonObject rules;
        String rulesLocation = this.config().getString("obfuscationRules");
        try (InputStream stream = FSUtils.openUrlStream(this.getClass(), (String)rulesLocation);){
            rules = (JsonObject)JsonUtils.mapper().readValue((Reader)new InputStreamReader(stream, JsonUtils.UTF_8), JsonObject.class);
        }
        HashSet<String> processedIds = new HashSet<String>();
        for (String type : processByTypes) {
            processedIds.addAll(this.processAllNodesByType(rules, type));
        }
        processedIds.addAll(this.processComponents(rules));
        processedIds.addAll(this.processUtilities(rules));
        Graph graph = this.graph;
        for (JsonObject vertex : graph.vertexList()) {
            String vertexId = vertex.getString("id");
            if (processedIds.contains(vertexId)) continue;
            this.getLogger().info("Unknown vertex {} dropped", (Object)vertexId);
            graph.removeVertex(vertex);
        }
        this.taskCompleted(taskPromise);
    }

    protected Collection<String> processComponents(JsonObject allRules) {
        List components = this.V(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).toList();
        return this.processNodes(allRules, "*component*", components);
    }

    protected Collection<String> processUtilities(JsonObject allRules) {
        List vertices = this.V("Info", "Infra", "Spec").toList();
        return vertices.stream().flatMap(vertex -> this.processNodes(allRules, vertex.getString("type"), Collections.singletonList(vertex)).stream()).collect(Collectors.toSet());
    }

    protected Collection<String> processAllNodesByType(JsonObject allRules, String type) {
        List nodes = this.V(new String[0]).hasType(new String[]{type}).toList();
        return this.processNodes(allRules, type, nodes);
    }

    protected Collection<String> processNodes(JsonObject allRules, String refType, List<JsonObject> vertices) {
        JsonObject rulesForType = (JsonObject)JsonPointer.from((String)("/vertices/byType/" + refType)).queryJson((Object)allRules);
        return this.processByRule(rulesForType, refType, vertices);
    }

    protected Collection<String> processByRule(JsonObject rules, String refType, List<JsonObject> vertices) {
        return vertices.stream().peek(vertex -> this.processByRule(rules, refType, (JsonObject)vertex)).map(vertex -> vertex.getString("id")).collect(Collectors.toSet());
    }

    protected void processByRule(JsonObject rules, String refType, JsonObject vertex) {
        String ruleType;
        String vertexId = vertex.getString("id");
        String vertexType = vertex.getString("type");
        if (rules == null) {
            this.getLogger().debug("Vertex {} kept intact. Type: {}", (Object)vertexId, (Object)vertexType);
            return;
        }
        switch (ruleType = rules.getString("rule", "")) {
            case "drop": {
                this.graph.removeVertex(vertex);
                this.getLogger().info("Vertex {} dropped. Type: {}", (Object)vertexId, (Object)vertexType);
                break;
            }
            case "truncate": {
                Trie wlPrefixes = this.prefixesByType.computeIfAbsent(refType, key -> this.generateTrie(rules.getJsonArray("allowList")));
                this.truncateMapRecursively(vertex.getMap(), (Trie<String, Boolean>)wlPrefixes, "/");
                break;
            }
            case "saveByChildren": {
                this.saveByChildren(vertex);
                break;
            }
            default: {
                this.getLogger().error("Unknown rule type: {}", (Object)ruleType);
            }
        }
    }

    protected Trie<String, Boolean> generateTrie(JsonArray allowList) {
        PatriciaTrie trie = new PatriciaTrie();
        for (Object prefix : allowList.getList()) {
            trie.put((Object)("/" + String.valueOf(prefix) + "/").replaceAll("/+", "/"), (Object)Boolean.TRUE);
        }
        for (String prefix : alwaysPreserve) {
            trie.put((Object)prefix, (Object)Boolean.TRUE);
        }
        return trie;
    }

    protected void truncateMapRecursively(Map<String, Object> map, Trie<String, Boolean> wlPrefixes, String path) {
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String keyPath = path + e.getKey() + "/";
            SortedMap p = wlPrefixes.prefixMap((Object)keyPath);
            if (p.isEmpty()) {
                this.getLogger().debug("Dropped path {}", (Object)keyPath);
                it.remove();
                continue;
            }
            if (p.containsKey(keyPath)) continue;
            this.truncateObjectRecursively(e.getValue(), wlPrefixes, keyPath);
        }
    }

    protected void truncateListRecursively(List<Object> list, Trie<String, Boolean> wlPrefixes, String path) {
        for (Object o : list) {
            this.truncateObjectRecursively(o, wlPrefixes, path);
        }
    }

    protected void truncateObjectRecursively(Object value, Trie<String, Boolean> wlPrefixes, String path) {
        if (value instanceof Map) {
            this.truncateMapRecursively((Map)value, wlPrefixes, path);
        } else if (value instanceof JsonObject) {
            this.truncateMapRecursively(((JsonObject)value).getMap(), wlPrefixes, path);
        } else if (value instanceof List) {
            this.truncateListRecursively((List)value, wlPrefixes, path);
        } else if (value instanceof JsonArray) {
            this.truncateListRecursively(((JsonArray)value).getList(), wlPrefixes, path);
        }
    }

    protected void saveByChildren(JsonObject vertex) {
        String vertexId = vertex.getString("id");
        Long childrenCount = (Long)this.V(vertexId).out(new String[0]).count().next();
        if (childrenCount == 0L) {
            this.getLogger().info("Vertex {} dropped due to lack of children. Type: {}", (Object)vertexId, (Object)vertex.getString("type"));
            this.graph.removeVertex(vertex);
        }
    }
}

