/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.other;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.GitUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichDocumentationLinksVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(EnrichDocumentationLinksVerticle.class);
    private static String[] patterns = new String[]{"ReadMe.md", "docs", "documents", "documentation"};
    private JsonPointer docsPtr = JsonPointer.from((String)"/details/documentationLink");

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        Integer coresCount = CpuCoreSensor.availableProcessors();
        WorkerExecutor executor = this.vertx.createSharedWorkerExecutor("enrichment-worker-pool", coresCount.intValue(), 10L, TimeUnit.MINUTES);
        List components = this.V(new String[0]).hasType(new String[]{"domain"}).out(new String[0]).hasKeys(new String[]{"directoryPath"}).toList();
        ArrayList<Future> blockingFutures = new ArrayList<Future>();
        for (JsonObject component : components) {
            blockingFutures.add(executor.executeBlocking(promise -> this.enrichComponentWithDocs(component, (Promise<Object>)promise)));
        }
        this.completeCompositeTask(blockingFutures, taskPromise);
    }

    private void enrichComponentWithDocs(JsonObject component, Promise<Object> promise) {
        JsonArray additionalDocLinks = new JsonArray();
        String directoryPath = FSUtils.getComponentDirPath((JsonObject)component);
        for (String pattern : patterns) {
            File file = new File(directoryPath, pattern);
            if (!file.exists()) continue;
            try {
                additionalDocLinks.add((Object)GitUtils.buildRepositoryLink((JsonObject)component, (String)file.getCanonicalPath(), (JsonObject)this.config()));
            }
            catch (IOException e) {
                this.report.exceptionThrown(component, (Exception)e);
            }
        }
        JsonArray documentation = JsonUtils.getOrCreateJsonArray((JsonObject)component, (JsonPointer)this.docsPtr);
        documentation.addAll(additionalDocLinks);
        if (!documentation.isEmpty()) {
            this.docsPtr.writeJson((Object)component, (Object)documentation, true);
        }
        promise.complete();
    }
}

