/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessGitInfoFilesTask
extends AbstractParseFileTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProcessGitInfoFilesTask.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"git.info"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        JsonObject gitInfo = JsonUtils.readJsonFile((String)fileName);
        String branch = gitInfo.getString("branch");
        if (StringUtils.isNotEmpty((CharSequence)branch)) {
            this.getLogger().info("Setting branch {} for {} from git.info", (Object)branch, (Object)component.getString("id"));
            JsonPointer releaseBranchPtr = JsonPointer.from((String)"/details/releaseBranch");
            releaseBranchPtr.writeJson((Object)component, (Object)branch, true);
            component.put("releaseBranch", (Object)branch);
        }
    }
}

