/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.java;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseRouteAnnotationVerticle
extends AbstractParseFileTask {
    protected Logger LOG = LoggerFactory.getLogger(ParseRouteAnnotationVerticle.class);
    final Pattern GATEWAY_TYPE_PATTERN = Pattern.compile("(PUBLIC|PRIVATE|INTERNAL|FACADE)", 2);
    final String ROUTE_ANNOTATION = "@Route";

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"*.java"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        this.getLogger().trace("{}: Searching for @Route annotation in file '{}'", (Object)component.getString("id"), (Object)fileName);
        JsonPointer pluginsPointer = JsonPointer.from((String)"/details/gateways");
        HashSet<String> gatewaysSet = new HashSet<String>();
        JsonArray gateways = (JsonArray)pluginsPointer.queryJson((Object)component);
        if (gateways != null) {
            gatewaysSet.addAll(gateways.getList());
        }
        String fileContents = FSUtils.readFileSafe((String)fileName);
        String[] fileLines = fileContents.split("[\\n\\r]{1,2}");
        String componentId = component.getString("id");
        for (String fileLine : fileLines) {
            Matcher matcher;
            if (!fileLine.startsWith("@Route") || !(matcher = this.GATEWAY_TYPE_PATTERN.matcher(fileLine)).find()) continue;
            String gateway = matcher.group().toLowerCase();
            gatewaysSet.add(gateway);
            this.getLogger().debug("{}: Route configuration '{}' is found in file '{}'", new Object[]{componentId, gateway, fileName});
            break;
        }
        if (!gatewaysSet.isEmpty()) {
            pluginsPointer.writeJson((Object)component, (Object)new JsonArray(gatewaysSet.stream().collect(Collectors.toList())));
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

