/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.Promise;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesCommitResultsVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesCommitResultsVerticle.class);
    @Resource
    @Nullable
    private GitAdapter gitAdapter;

    @Override
    protected String[] features() {
        return new String[]{"repositoryUpdate", "unskippable"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        if (this.gitAdapter == null) {
            this.getLogger().warn("Offline mode. Exitting.");
            this.taskCompleted(taskPromise);
            return;
        }
        this.gitAdapter.openSuperrepository().compose(repo -> this.gitAdapter.gitAdd(repo, ".").compose(r -> this.gitAdapter.gitStatus(repo)).compose(status -> {
            Set missing = status.getMissing();
            SucceededFuture commitFuture = SucceededFuture.EMPTY;
            String commitMessage = "Automatic commit on '" + ConfigUtils.getConfigValue((String)"/git/releaseBranch", (JsonObject)this.config()) + "' snapshot";
            if (missing.isEmpty()) {
                if (!status.isClean()) {
                    commitFuture = this.gitAdapter.gitCommit(repo, commitMessage);
                }
            } else {
                commitFuture = this.gitAdapter.gitRm(repo, (Collection)missing).compose(r -> this.gitAdapter.gitCommit(repo, commitMessage));
            }
            return commitFuture;
        })).onSuccess(r -> this.taskCompleted(taskPromise)).onFailure(r -> {
            this.report.internalError("Commit in super repository failed: " + ExceptionUtils.getStackTrace((Throwable)r));
            this.taskCompleted(taskPromise);
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

