/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitFileRetriever;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesPrepareSuperRepositoryVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesPrepareSuperRepositoryVerticle.class);
    @Resource
    @Nullable
    private GitFileRetriever gitFileRetriever;
    @Resource
    @Nullable
    private GitAdapter gitAdapter;

    @Override
    protected String[] features() {
        return new String[]{"repositoryUpdate"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        if (this.gitAdapter == null || this.gitFileRetriever == null) {
            this.getLogger().warn("Offline mode. Exitting.");
            this.taskCompleted(taskPromise);
            return;
        }
        this.updateRepositories().onFailure(f -> this.report.internalError("Failed to update repository: " + ExceptionUtils.getStackTrace((Throwable)f))).onComplete(r -> this.taskCompleted(taskPromise));
    }

    private Future<Void> updateRepositories() {
        List jsonObjectList = this.V(new String[0]).hasType(new String[]{"domain"}).as("domain", new String[0]).out(new String[0]).hasKeys(new String[]{"directoryPath"}).as("component", new String[0]).select(new String[]{"domain", "component"}).toList();
        String targetRelease = ConfigUtils.getConfigValue((String)"/release", (JsonObject)this.config());
        String sourceRelease = ConfigUtils.getConfigValue((String)"/priorRelease", (JsonObject)this.config());
        boolean compareRequired = ConfigUtils.isFeatureEnabled((String)"compareReleases", (JsonObject)this.config());
        Future updateRepoFuture = this.gitAdapter.prepareSuperRepository().compose(superRepository -> {
            SucceededFuture previousReleaseCopyFuture = SucceededFuture.EMPTY;
            if (compareRequired && sourceRelease != null && !sourceRelease.equals(targetRelease)) {
                previousReleaseCopyFuture = this.gitAdapter.switchSuperRepoBranch(superRepository, sourceRelease).compose(r -> this.getFilesList()).compose(list -> CompositeFuture.join((List)this.gitFileRetriever.copyFilesFromRepo(superRepository, sourceRelease, (List)list)));
            }
            Future resultFuture = previousReleaseCopyFuture.compose(r -> this.gitAdapter.switchSuperRepoBranch(superRepository, targetRelease)).compose(r -> {
                List futures = this.gitAdapter.bulkSubmoduleAdd(superRepository, jsonObjectList);
                return CompositeFuture.join((List)futures);
            }).compose(r -> this.gitAdapter.gitStatusCheck(superRepository, s -> !CollectionUtils.isEmpty((Collection)s.getAdded()))).compose(r -> {
                if (((Boolean)r).booleanValue()) {
                    return this.gitAdapter.gitCommit(superRepository, "New repositories added");
                }
                return SucceededFuture.EMPTY;
            }).compose(res -> this.gitAdapter.submoduleUpdate(superRepository).onComplete(h -> superRepository.close()));
            return resultFuture;
        });
        return updateRepoFuture;
    }

    private Future<List<Path>> getFilesList() {
        return this.vertx.fileSystem().readFile(ConfigUtils.getConfigFilePath((JsonObject)this.config(), (String[])new String[]{"config", "diffConfig.json"}).toString()).map(fileContents -> {
            JsonObject jsonResult = new JsonObject(fileContents);
            List filesArray = jsonResult.getJsonArray("files").stream().map(str -> Path.of((String)str, new String[0])).collect(Collectors.toList());
            return filesArray;
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

