/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesSetPathVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesSetPathVerticle.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        List jsonObjectList = this.V(new String[0]).hasType(new String[]{"domain"}).as("domain", new String[0]).out(new String[0]).hasKeys(new String[]{"repository"}).as("component", new String[0]).select(new String[]{"domain", "component"}).toList();
        for (Map json : jsonObjectList) {
            JsonObject component = (JsonObject)json.get("component");
            JsonObject domain = (JsonObject)json.get("domain");
            String directoryPath = this.buildDirectoryPath(ConfigUtils.getConfigValue((String)"/git/superRepositoryDir", (JsonObject)this.config()), ConfigUtils.getConfigValue((String)"/git/superRepositoryModulesDir", (JsonObject)this.config()), component, domain).getPath();
            component.put("directoryPath", (Object)directoryPath);
        }
        this.taskCompleted(taskPromise);
    }

    private File buildDirectoryPath(String cloneRootFolderName, String submodulesDir, JsonObject component, JsonObject domain) {
        String domainId = domain.getString("id");
        String compId = component.getString("id");
        File dir = Path.of(cloneRootFolderName, submodulesDir, domainId, compId).toFile();
        if (dir.isDirectory()) {
            return dir;
        }
        dir = Path.of(cloneRootFolderName, submodulesDir, domainId.replaceFirst("^D_", ""), compId).toFile();
        return dir;
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

