/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.impl.launcher.commands.ClasspathHandler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VerticleFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.qubership.itool.cli.FlowMainVerticle;
import org.qubership.itool.cli.config.ConfigProvider;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.di.ApplicationContext;
import org.qubership.itool.di.QubershipModule;
import org.qubership.itool.factories.JavaAppContextVerticleFactory;
import org.qubership.itool.modules.graph.GraphService;
import org.slf4j.Logger;

public abstract class AbstractCommand
extends ClasspathHandler {
    protected Map<String, String> properties = new HashMap<String, String>(Map.of("/profile", "dev", "/configPath", "inventory-tool"));

    protected abstract Logger getLogger();

    public void runFlow(FlowMainVerticle main, GraphService graphService) {
        Vertx vertx = Vertx.vertx();
        vertx.exceptionHandler(err -> {
            this.getLogger().error("Critical error, application is stopping", err);
            System.exit(1);
        });
        this.runFlow(vertx, main, graphService).onComplete(ar -> {
            if (ar.failed()) {
                this.getLogger().error("Flow execution failed", ar.cause());
                System.exit(1);
            }
            System.exit(0);
        });
    }

    protected Future<?> runFlow(Vertx vertx, FlowMainVerticle main, GraphService graphService) {
        ConfigProvider configProvider = new ConfigProvider(this.properties, vertx);
        return Future.future(promise -> configProvider.handleConfig((Handler<AsyncResult<JsonObject>>)((Handler)ar -> this.configLoaded(vertx, main, graphService, (JsonObject)ar.result(), (Promise)promise))));
    }

    protected void configLoaded(Vertx vertx, FlowMainVerticle main, GraphService graphService, JsonObject config, Promise promise) {
        try {
            JavaAppContextVerticleFactory javaTaskFactory;
            ApplicationContext context = new ApplicationContext(vertx, config, this.createModules(vertx));
            FlowContext flowContext = context.getInstance(FlowContext.class);
            Optional<VerticleFactory> factory = vertx.verticleFactories().stream().filter(f -> f instanceof JavaAppContextVerticleFactory).findAny();
            if (factory.isEmpty()) {
                javaTaskFactory = new JavaAppContextVerticleFactory(flowContext, config);
                vertx.registerVerticleFactory((VerticleFactory)javaTaskFactory);
            } else {
                javaTaskFactory = (JavaAppContextVerticleFactory)factory.get();
            }
            flowContext.initialize(vertx, config);
            flowContext.setTaskClassLoader(javaTaskFactory.getTaskClassLoader());
            main.deployAndRunFlow(flowContext).onComplete(flowResult -> {
                promise.handle(flowResult);
                this.flowFinished(main, (AsyncResult<?>)flowResult);
            });
        }
        catch (Throwable ex) {
            promise.fail(ex);
        }
    }

    private Module[] createModules(Vertx vertx) {
        Module overrideModule = this.createOverrideModule(vertx);
        if (overrideModule != null) {
            return new Module[]{Modules.override((Module[])new Module[]{new QubershipModule(vertx)}).with(new Module[]{overrideModule})};
        }
        return new Module[]{new QubershipModule(vertx)};
    }

    protected Module createOverrideModule(Vertx vertx) {
        return null;
    }

    protected void flowFinished(FlowMainVerticle main, AsyncResult<?> flowResult) {
        main.undeploy();
        if (flowResult.succeeded()) {
            this.getLogger().info("Flow succeeded. Undeploying and terminating.");
        } else {
            this.getLogger().error("Flow failed. Undeploying and terminating.", flowResult.cause());
        }
    }

    @Option(longName="set", argName="set", required=false)
    @Description(value="Universal setter: name=value (multiple)")
    public void setProperty(String[] params) {
        for (String param : params) {
            String[] pair = param.split("=", 2);
            this.properties.put(pair[0], pair.length > 1 ? pair[1] : "");
        }
    }

    @Option(longName="configPath", argName="configPath", shortName="c", required=false)
    @Description(value="Path to folder containing the configuration files")
    public void setConfigPath(String configPath) {
        this.properties.put("/configPath", configPath);
    }

    @Option(longName="profile", argName="profile", shortName="p", required=false)
    @Description(value="Custom profile to be used. By default uses properties format, in case of json, use file name with extension (Examples: \"custom\", \"custom.properties\", \"custom_example.json\")")
    public void setProfile(String profile) {
        this.properties.put("/profile", profile);
    }
}

