/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.QueryVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="query")
@Summary(value="Execute Gremlin query")
public class QueryCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public QueryCommand() {
        this.properties.put("offlineMode", "true");
    }

    public void run() throws CLIException {
        this.runFlow(new QueryVerticle(), null);
    }

    @Option(longName="file", argName="file", shortName="f", required=false)
    @Description(value="JSON file that CLI should load instead of Graph dump")
    public void setFile(String file) {
        this.properties.put("/query/file", file);
    }

    @Option(longName="step", argName="step", shortName="s", required=false)
    @Description(value="Execution step for query (default is 'result' step)")
    public void setStep(String step) {
        this.properties.put("/query/step", step);
    }

    @Option(longName="login", argName="login", shortName="l", required=false)
    @Description(value="Login to access services requiring authentication")
    public void setLogin(String login) {
        this.properties.put("login", login);
    }

    @Option(longName="passwordSource", argName="passwordSource", shortName="pws", required=false)
    @Description(value="Password source, default: \"file:password.txt\"")
    public void setPasswordSource(String passwordSource) {
        this.properties.put("passwordSource", passwordSource);
    }

    @Option(longName="progressPath", argName="progressPath", shortName="pp", required=false)
    @Description(value="Path to progress folder (default is 'progress')")
    public void setProgressPath(String progressPath) {
        this.properties.put("/query/progressPath", progressPath);
    }
}

