/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.cli.FlowMainVerticle;
import org.qubership.itool.cli.query.CliQuery;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryVerticle
extends FlowMainVerticle {
    protected static final Logger LOG = LoggerFactory.getLogger(QueryVerticle.class);
    @Resource
    protected Provider<Graph> graphProvider;

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void start() {
        WorkerExecutor executor = this.vertx.createSharedWorkerExecutor("query-worker-pool", 1, 60L, TimeUnit.DAYS);
        JsonObject config = this.config();
        String file = ConfigUtils.getConfigValue("/query/file", config);
        String step = ConfigUtils.getConfigValue("/query/step", config);
        if (StringUtils.isNotEmpty((CharSequence)file)) {
            this.startFromFile(this.vertx, config, executor, file);
        } else if (StringUtils.isNotEmpty((CharSequence)step)) {
            this.startFromStep(this.vertx, config, executor, step);
        } else {
            System.out.println("ERROR: Please specify 'file', or 'step', or 'appId' for CLI");
        }
    }

    private void startFromStep(Vertx vertx, JsonObject config, WorkerExecutor executor, String step) {
        Path progressPath = Path.of(ConfigUtils.getConfigValue("/git/superRepositoryDir", config), ConfigUtils.getConfigValue("/query/progressPath", config), "task." + step + ".json");
        executor.executeBlocking(p -> {
            JsonObject dump = null;
            try {
                dump = JsonUtils.readJsonFile(progressPath.toString());
            }
            catch (IOException e) {
                p.fail((Throwable)e);
            }
            if (dump == null) {
                p.fail("Dump is empty or not found for step " + step);
            }
            Graph graph = (Graph)this.graphProvider.get();
            GraphDumpSupport.restoreFromJson(graph, dump);
            if (graph.getVertexCount() == 1) {
                p.fail("Graph is empty for step " + step);
                return;
            }
            dump = null;
            System.out.println("Inventory tool Gremlin CLI");
            System.out.println("Graph restored from file: " + String.valueOf(progressPath.normalize()));
            System.out.println("Total Vertex count: " + graph.getVertexCount());
            System.out.println("For help please enter: help;");
            CliQuery cli = new CliQuery(graph);
            cli.run();
        }).onFailure(f -> {
            System.out.println("Gremlin CLI failed to run:\n" + ExceptionUtils.getStackTrace((Throwable)f));
            vertx.close();
        });
    }

    private void startFromFile(Vertx vertx, JsonObject config, WorkerExecutor executor, String file) {
        Path filePath = Path.of(file, new String[0]);
        executor.executeBlocking(p -> {
            String content = null;
            try {
                content = FSUtils.readFileAsIs(filePath.toString());
            }
            catch (IOException e) {
                p.fail((Throwable)e);
            }
            if (content == null) {
                p.fail("Empty data");
            }
            Graph graph = (Graph)this.graphProvider.get();
            if (content.startsWith("[")) {
                this.loadFromJsonArray(file, graph, (Promise<Object>)p, content);
            } else {
                GraphDumpSupport.restoreFromJson(graph, new JsonObject(content));
            }
            content = null;
            System.out.println("Inventory tool Gremlin CLI");
            System.out.println("Graph restored from file: " + String.valueOf(filePath.normalize()));
            System.out.println("Total Vertex count: " + graph.getVertexCount());
            System.out.println("Total Edges count: " + graph.getEdgeCount());
            System.out.println("For help please enter: help;");
            CliQuery cli = new CliQuery(graph);
            cli.run();
        }).onFailure(f -> {
            System.out.println("Gremlin CLI failed to run:\n" + ExceptionUtils.getStackTrace((Throwable)f));
            vertx.close();
        });
    }

    private void loadFromJsonArray(String file, Graph graph, Promise<Object> p, String content) {
        JsonArray jsonArray = null;
        try {
            jsonArray = new JsonArray(content);
        }
        catch (Exception e) {
            p.fail((Throwable)e);
        }
        if (jsonArray == null) {
            p.fail("JSON file is empty or not found. File: " + file);
        }
        for (Object json : jsonArray) {
            JsonObject jsonObj;
            if (!(json instanceof JsonObject)) {
                p.fail("JsonObject expected. Found scalar: " + String.valueOf(json));
            }
            if ((jsonObj = (JsonObject)json).getValue("id") == null) {
                p.fail("JsonObject should contain 'id' property");
            }
            graph.addVertex(jsonObj);
        }
    }

    @Override
    protected List<String> getFlowSequence() {
        return null;
    }
}

