/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.extract;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import java.util.Properties;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.extract.ExtractMainVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="extract")
@Summary(value="Extract Language and Framework data from Graph")
public class ExtractCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public ExtractCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
    }

    public void run() throws CLIException {
        this.getLogger().info("Graph data extraction flow execution");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("inputFile: {}", this.properties.get("ciInputFile"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.runFlow(new ExtractMainVerticle(), null);
    }

    @Option(longName="inputFile", argName="inputFile", required=true)
    @Description(value="Input file name")
    public void setInputFile(String inputFile) {
        this.properties.put("ciInputFile", inputFile);
    }

    @Option(longName="outputFile", argName="outputFile", required=true)
    @Description(value="Output file name")
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }
}

