/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.obfuscate;

import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import java.util.Properties;
import org.qubership.itool.cli.ExecCommand;
import org.qubership.itool.cli.obfuscate.ObfuscationMainVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="ci-obfuscate")
@Summary(value="Obfuscate Graph")
public class ObfuscateCommand
extends ExecCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObfuscateCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public ObfuscateCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
    }

    @Override
    public void run() throws CLIException {
        this.getLogger().info("Obfuscation main flow execution");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.getLogger().info("inputDirectory: {}", this.properties.get("ciInputDirectory"));
        this.getLogger().info("inputFile: {}", this.properties.get("ciInputFile"));
        this.getLogger().info("explicit outputDirectory: {}", this.properties.get("ciOutputDirectory"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.runFlow(new ObfuscationMainVerticle(), null);
    }

    @Option(longName="inputDirectory", argName="inputDirectory", required=false)
    @Description(value="Input directory")
    public void setInputDirectory(String inputDirectory) {
        this.properties.put("ciInputDirectory", inputDirectory);
    }

    @Option(longName="inputFile", argName="inputFile", required=true)
    @Description(value="Input file name")
    public void setInputFile(String inputFile) {
        this.properties.put("ciInputFile", inputFile);
    }

    @Option(longName="outputDirectory", argName="outputDirectory", required=false)
    @Description(value="Output directory")
    public void setOutputDirectory(String outputDirectory) {
        this.properties.put("ciOutputDirectory", outputDirectory);
    }

    @Option(longName="outputFile", argName="outputFile", required=true)
    @Description(value="Output file name")
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @Option(longName="obfuscationRules", argName="obfuscationRules", shortName="rules", required=false)
    @Description(value="Path to the obfuscated graph dump")
    public void setObfuscationRules(String obfuscationRules) {
        this.properties.put("obfuscationRules", obfuscationRules);
    }
}

