/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.QueryItem;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;
import org.qubership.itool.cli.query.cmd.CliCommand;
import org.qubership.itool.modules.gremlin2.GremlinException;

public class DoPredefinedQueryCommand
extends AbstractCliCommand {
    public DoPredefinedQueryCommand(CliContext context) {
        super(context);
    }

    @Override
    public String name() {
        return "do XXX;";
    }

    @Override
    public String description() {
        return "Execute predefined Gremlin queries. Example: do (1); do someQuery();";
    }

    @Override
    public boolean acceptCommand(String command) {
        return command.startsWith("do ");
    }

    @Override
    public Object doCommand(String command) {
        int index;
        QueryItem queryItem = null;
        List<QueryItem> queryItems = this.getQueryItems();
        String method = command.trim().substring("do ".length());
        method = method.substring(0, method.length() - 1);
        Pattern pattern = Pattern.compile("^\\((\\d+)\\)$");
        Matcher matcher = pattern.matcher(method);
        if (matcher.matches() && (index = Integer.parseInt(matcher.group(1))) >= 1 && index <= queryItems.size()) {
            queryItem = queryItems.get(index - 1);
        }
        if (queryItem == null) {
            boolean success = false;
            for (QueryItem tmp : queryItems) {
                if (method.equals(tmp.getMethod())) {
                    success = true;
                    queryItem = tmp;
                    break;
                }
                if (success) continue;
                System.out.println("Predefined query not found: " + method);
                return null;
            }
        }
        System.out.println(queryItem.getDescription());
        System.out.println(queryItem.getQuery());
        this.executeGremlinQuery(queryItem.getQuery());
        return null;
    }

    private Object executeGremlinQuery(String query) throws GremlinException {
        Object result = null;
        for (CliCommand command : this.context.getCommands()) {
            if (!command.acceptCommand(query)) continue;
            command.doCommand(query);
            break;
        }
        return result;
    }

    private List<QueryItem> getQueryItems() {
        return (List)this.context.getValue("queryItems");
    }
}

