/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.ArrayList;
import java.util.List;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.QueryFileParser;
import org.qubership.itool.cli.query.QueryItem;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;

public class ListPredefinedQueriesCommand
extends AbstractCliCommand {
    public static final String QUERY_ITEMS = "queryItems";
    public static final String QUERY_DEFAULT_TXT = "inventory-tool/default/config/cli/query_default.txt";
    public static final String QUERY_CUSTOM_TXT = "inventory-tool/default/config/cli/query_custom.txt";
    private List<QueryItem> queryItems = new ArrayList<QueryItem>();

    public ListPredefinedQueriesCommand(CliContext context) {
        super(context);
        QueryFileParser parser = new QueryFileParser();
        parser.parse(this.queryItems, QUERY_DEFAULT_TXT);
        parser.parse(this.queryItems, QUERY_CUSTOM_TXT);
        context.setValue(QUERY_ITEMS, this.queryItems);
    }

    @Override
    public String name() {
        return "list;";
    }

    @Override
    public String description() {
        return "List predefined Gremlin queries";
    }

    @Override
    public boolean acceptCommand(String command) {
        return "list;".equals(command);
    }

    @Override
    public Object doCommand(String command) {
        this.commandList(command);
        return null;
    }

    private void commandList(String command) {
        System.out.println("Predefined query list:");
        for (int i = 0; i < this.queryItems.size(); ++i) {
            System.out.println("(" + (i + 1) + ")\t" + this.queryItems.get(i).getMethod() + " --- " + this.queryItems.get(i).getDescription());
        }
    }
}

