/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Pattern;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;

public class PropertyListCommand
extends AbstractCliCommand {
    private static final Pattern PATTERN = Pattern.compile("^\\s*show\\s+properties\\s*;\\s*$");
    Properties props;

    public PropertyListCommand(CliContext context) {
        super(context);
        this.props = (Properties)context.getValue("properties");
    }

    @Override
    public String name() {
        return "show properties;";
    }

    @Override
    public String description() {
        return "Show properties name and current values";
    }

    @Override
    public boolean acceptCommand(String command) {
        return PATTERN.matcher(command).matches();
    }

    @Override
    public Object doCommand(String command) {
        Enumeration<Object> enumeration = this.props.keys();
        System.out.println("Current settings:");
        for (String key : this.props.stringPropertyNames()) {
            System.out.println(key + " = " + this.props.getProperty(key));
        }
        return null;
    }
}

