/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;

public class PropertySetCommand
extends AbstractCliCommand {
    Properties props;

    public PropertySetCommand(CliContext context) {
        super(context);
        this.props = (Properties)context.getValue("properties");
    }

    @Override
    public String name() {
        return "set <property> = <name>;";
    }

    @Override
    public String description() {
        return "Set value for the specified property";
    }

    @Override
    public boolean acceptCommand(String command) {
        return command.startsWith("set ");
    }

    @Override
    public Object doCommand(String command) {
        Pattern pattern = Pattern.compile("^set\\s+([a-zA-Z\\.]+)\\s*=\\s*(.+)\\s*;\\s*$");
        Matcher matcher = pattern.matcher(command);
        if (!matcher.matches()) {
            System.out.println("Wrong set command: " + command);
            return null;
        }
        String property = matcher.group(1);
        String value = matcher.group(2);
        if (!this.props.containsKey(property)) {
            System.out.println("Wrong property name: " + property);
            System.out.print("Possible name: ");
            StringBuilder builder = new StringBuilder();
            for (String key : this.props.stringPropertyNames()) {
                builder.append(key).append(", ");
            }
            String propertyNames = builder.toString();
            System.out.println(propertyNames.substring(0, propertyNames.length() - 2));
            return null;
        }
        if (property.equals("result.limit")) {
            this.props.put(property, Integer.valueOf(value));
        } else {
            this.props.put(property, value);
        }
        return null;
    }
}

