/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.context;

import com.google.inject.Injector;
import com.google.inject.Key;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphClassifier;
import org.qubership.itool.modules.graph.GraphClassifierBuilder;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.graph.GraphService;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowContextImpl
implements FlowContext {
    private static final Logger LOG = LoggerFactory.getLogger(FlowContextImpl.class);
    private final String flowInstanceId = UUID.randomUUID().toString();
    private final Map<Class<?>, Object> resources = new HashMap();
    private Graph graph;
    private GraphService graphService;
    private GraphClassifier graphClassifier;
    private GraphReport report;
    private JsonObject config;
    private ClassLoader taskClassLoader;
    private Vertx vertx;
    private boolean breakRequested;
    private final Injector injector;
    private final GraphClassifierBuilder graphClassifierBuilder;

    @Inject
    public FlowContextImpl(Injector injector, Graph graph, GraphClassifierBuilder graphClassifierBuilder) {
        this.injector = injector;
        this.graph = graph;
        this.report = graph.getReport();
        this.graphClassifierBuilder = graphClassifierBuilder;
    }

    @Override
    public void initialize(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
        if (this.graphService != null) {
            this.resources.put(GraphService.class, this.graphService);
        }
        if (this.graphClassifier != null) {
            this.resources.put(GraphClassifier.class, this.graphClassifier);
        }
    }

    @Override
    public void initialize(Object task) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = task.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        this.setAnnotatedFieldValues(task, fields);
        LOG.debug("Dependency injections for task {} complete", task);
    }

    @Override
    public <T> T getResource(Class<T> clazz) {
        return (T)this.resources.get(clazz);
    }

    @Override
    public Map<Class<?>, Object> getResources() {
        return this.resources;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void setGraphService(GraphService graphService) {
        this.graphService = graphService;
        if (graphService != null) {
            this.graphClassifier = this.graphClassifierBuilder.setId("flow-" + this.flowInstanceId).setWithReport(true).build();
            graphService.putGraph(this.graphClassifier, this.graph);
            LOG.info("[fiid={}]: Graph @{} created for {}", new Object[]{this.flowInstanceId, System.identityHashCode(this.graph), this.graphClassifier});
        } else {
            LOG.info("[fiid={}]: Graph @{} created, not attached to graph service", (Object)this.flowInstanceId, (Object)System.identityHashCode(this.graph));
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public GraphReport getReport() {
        return this.report;
    }

    private void setAnnotatedFieldValues(Object obj, List<Field> fields) {
        for (Field field : fields) {
            Resource annotation = field.getDeclaredAnnotation(Resource.class);
            if (annotation == null) continue;
            Class<?> fieldType = field.getType();
            Object resource = this.resources.get(fieldType);
            if (resource == null) {
                try {
                    Key key = Key.get((Type)field.getGenericType());
                    resource = this.injector.getInstance(key);
                }
                catch (Exception e) {
                    LOG.warn("Could not get instance for field {} of type {}: {}", new Object[]{field.getName(), field.getGenericType(), e.getMessage()});
                }
            }
            if (resource != null) {
                this.setFieldValue(obj, field, resource);
                LOG.trace("Field {} of {} was updated with value {}", new Object[]{field.getName(), obj, resource});
                continue;
            }
            if (field.getDeclaredAnnotation(Nullable.class) != null) {
                LOG.warn("No resource provided for " + String.valueOf(fieldType) + " in " + obj.getClass().getName());
                continue;
            }
            throw new IllegalArgumentException("Resource not found for " + String.valueOf(fieldType) + " in " + obj.getClass().getName());
        }
    }

    private void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            LOG.error("Can't initialize " + String.valueOf(field.getType()) + " in the " + obj.getClass().getName() + ". Reason: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dumpDataToFile(File folder, String file) {
        JsonObject dump = GraphDumpSupport.dumpToJson(this.graph, false);
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        File progressFile = new File(folder, file);
        try {
            JsonUtils.saveJson(progressFile.toPath(), dump, true);
        }
        catch (IOException e) {
            LOG.error("Exception when saving progress file " + String.valueOf(progressFile), (Throwable)e);
        }
    }

    @Override
    public void restoreData(JsonObject dump) {
        GraphDumpSupport.restoreFromJson(this.graph, dump);
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    @Override
    public JsonObject getConfig() {
        return this.config;
    }

    @Override
    public ClassLoader getTaskClassLoader() {
        return this.taskClassLoader;
    }

    @Override
    public void setTaskClassLoader(ClassLoader taskClassLoader) {
        this.taskClassLoader = taskClassLoader;
    }

    @Override
    public void setBreakRequested(boolean breakRequested) {
        this.breakRequested = breakRequested;
    }

    @Override
    public boolean isBreakRequested() {
        return this.breakRequested;
    }

    @Override
    public String getFlowInstanceId() {
        return this.flowInstanceId;
    }

    @Override
    public GraphClassifier getGraphClassifier() {
        return this.graphClassifier;
    }
}

