/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.di;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.qubership.itool.di.ConfigModule;
import org.qubership.itool.di.QubershipModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContext {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContext.class);
    private final Injector injector;
    private final Vertx vertx;
    private final JsonObject config;

    public ApplicationContext(Vertx vertx, JsonObject config, Module[] modules) {
        this.vertx = vertx;
        this.config = config;
        logger.info("Creating ApplicationContext with {} modules", (Object)modules.length);
        for (int i = 0; i < modules.length; ++i) {
            logger.info("Module {}: {}", (Object)i, (Object)modules[i].getClass().getSimpleName());
        }
        Module[] allModules = new Module[modules.length + 1];
        allModules[0] = new ConfigModule(config);
        System.arraycopy(modules, 0, allModules, 1, modules.length);
        this.injector = Guice.createInjector((Module[])allModules);
        logger.info("ApplicationContext created successfully");
        this.logBindings();
    }

    private void logBindings() {
        logger.info("=== Guice Bindings ===");
        try {
            Map bindings = this.injector.getAllBindings();
            logger.info("Total bindings: {}", (Object)bindings.size());
            for (Map.Entry entry : bindings.entrySet()) {
                String key = ((Key)entry.getKey()).toString();
                String bindingType = ((Binding)entry.getValue()).getClass().getSimpleName();
                String source = ((Binding)entry.getValue()).getSource().toString();
                logger.info("  {} -> [{}] {}", new Object[]{key, bindingType, source});
            }
        }
        catch (Exception e) {
            logger.warn("Could not log bindings: {}", (Object)e.getMessage());
        }
        logger.info("=== End Guice Bindings ===");
    }

    public static ApplicationContext createDefault() {
        Vertx vertx = Vertx.vertx();
        return new ApplicationContext(vertx, new JsonObject(), new Module[]{new QubershipModule(vertx)});
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public Injector getInjector() {
        return this.injector;
    }
}

