/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.di;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.util.Properties;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.DiagramServiceImpl;
import org.qubership.itool.modules.diagram.providers.DomainDiagramProvider;
import org.qubership.itool.modules.diagram.providers.GeneralDomainsDiagramProvider;
import org.qubership.itool.modules.diagram.providers.InfrastructureDiagramProvider;
import org.qubership.itool.modules.diagram.providers.MicroserviceDiagramProvider;
import org.qubership.itool.modules.diagram.providers.QueueDiagramProvider;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphImpl;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.modules.report.GraphReportImpl;
import org.qubership.itool.modules.template.TemplateService;
import org.qubership.itool.modules.template.TemplateServiceImpl;

public class CoreModule
extends AbstractModule {
    private final Vertx vertx;

    public CoreModule(Vertx vertx) {
        this.vertx = vertx;
    }

    protected void configure() {
        this.bind(GraphReport.class).to(GraphReportImpl.class);
        this.bind(Vertx.class).toInstance((Object)this.vertx);
    }

    @Provides
    @Singleton
    public Graph provideGraph(Provider<GraphReport> graphReportProvider) {
        GraphImpl graph = new GraphImpl();
        graph.setReport((GraphReport)graphReportProvider.get());
        return graph;
    }

    @Provides
    @Singleton
    @Named(value="diagram.properties")
    public Properties provideDiagramProperties() {
        Properties diagramProperties = new Properties();
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.default.domain", "Gold");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.default.component", "Yellow");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.database", "DeepSkyBlue");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.queue", "GreenYellow");
        diagramProperties.setProperty("diagram.skinparam.backgroundColor.caching", "Orchid");
        return diagramProperties;
    }

    @Provides
    @Singleton
    public DiagramService provideDiagramService(Provider<Graph> graphProvider, @Named(value="diagram.properties") Properties diagramProperties) {
        DiagramServiceImpl diagramService = new DiagramServiceImpl((Graph)graphProvider.get(), diagramProperties);
        diagramService.register(new MicroserviceDiagramProvider());
        diagramService.register(new DomainDiagramProvider());
        diagramService.register(new GeneralDomainsDiagramProvider());
        diagramService.register(new InfrastructureDiagramProvider());
        diagramService.register(new QueueDiagramProvider());
        return diagramService;
    }

    @Provides
    @Singleton
    public TemplateService provideTemplateService(DiagramService diagramService, @Named(value="application.config") JsonObject config) {
        return new TemplateServiceImpl(diagramService, config);
    }
}

