/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.artifactory;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import org.qubership.itool.modules.artifactory.AppDBConfig;

public class AppDBConfigImpl
implements AppDBConfig {
    protected String url;
    protected String authMethod;
    protected String user;
    protected String password;
    protected String mavenEntry;

    public AppDBConfigImpl(String url, String user, String password, String mavenEntry) {
        this.url = url;
        this.authMethod = "basic";
        this.user = user;
        this.password = password;
        this.mavenEntry = mavenEntry;
    }

    public AppDBConfigImpl(JsonObject config) {
        this.url = (String)JsonPointer.from((String)"/appDB/url").queryJson((Object)config);
        this.authMethod = (String)JsonPointer.from((String)"/appDB/auth/method").queryJsonOrDefault((Object)config, (Object)"basic");
        switch (this.authMethod.toLowerCase()) {
            case "basic": {
                this.user = config.getString("login");
                this.password = config.getString("password");
                break;
            }
            default: {
                throw new IllegalArgumentException("/appDB/auth/method=" + this.authMethod + " not supported");
            }
        }
        this.mavenEntry = (String)JsonPointer.from((String)"/appDB/maven/entry").queryJsonOrDefault((Object)config, (Object)"SNAPSHOT_GROUP,TARGET_STAGING");
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getMavenEntry() {
        return this.mavenEntry;
    }
}

