/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.confluence;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import javax.annotation.Nullable;
import org.qubership.itool.modules.confluence.ConfluenceClient;
import org.qubership.itool.modules.confluence.ConfluenceClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceClientBuilder.class);

    @Nullable
    public static ConfluenceClient create(Vertx vertx, WebClient client, JsonObject config) {
        boolean offlineMode = Boolean.parseBoolean(config.getString("offlineMode"));
        if (offlineMode) {
            LOG.warn("Offline mode, Confluence facilities will not be available");
            return null;
        }
        String confluenceUrl = config.getString("confluenceUrl");
        if (confluenceUrl == null) {
            LOG.warn("No URL to confluence provided, Confluence facilities will not be available");
            return null;
        }
        String password = config.getString("password");
        String login = config.getString("login");
        if (login == null || password == null) {
            LOG.warn("No login or password provided, Confluence facilities will not be available");
            return null;
        }
        return new ConfluenceClientImpl(vertx, client, config);
    }
}

