/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram;

import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;

public class UMLDiagramEncoder {
    static final char[] encode6bit = new char[64];
    static final byte[] decode6bit = new byte[128];

    public static String encodeDiagram(String generatedText) {
        String uncommentData = UMLDiagramEncoder.trim(generatedText);
        byte[] data = uncommentData.getBytes(StandardCharsets.UTF_8);
        byte[] compressedData = UMLDiagramEncoder.compress(data);
        String encodedData = UMLDiagramEncoder.encode(compressedData);
        return encodedData;
    }

    private static byte[] compress(byte[] in) {
        int len = in.length * 2;
        if (len < 1000) {
            len = 1000;
        }
        Deflater compressor = new Deflater(9, true);
        compressor.setInput(in);
        compressor.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compressor.deflate(output);
        return !compressor.finished() ? null : UMLDiagramEncoder.copyArray(output, compressedDataLength);
    }

    private static byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }

    private static String encode(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder result = new StringBuilder((data.length * 4 + 2) / 3);
        for (int i = 0; i < data.length; i += 3) {
            UMLDiagramEncoder.append3bytes(result, data[i] & 0xFF, i + 1 < data.length ? data[i + 1] & 0xFF : 0, i + 2 < data.length ? data[i + 2] & 0xFF : 0);
        }
        return result.toString();
    }

    private static void append3bytes(StringBuilder sb, int b1, int b2, int b3) {
        int c1 = b1 >> 2;
        int c2 = (b1 & 3) << 4 | b2 >> 4;
        int c3 = (b2 & 0xF) << 2 | b3 >> 6;
        int c4 = b3 & 0x3F;
        sb.append(encode6bit[c1 & 0x3F]);
        sb.append(encode6bit[c2 & 0x3F]);
        sb.append(encode6bit[c3 & 0x3F]);
        sb.append(encode6bit[c4 & 0x3F]);
    }

    private static String trim(String arg) {
        return arg.length() == 0 ? arg : UMLDiagramEncoder.trimEndingInternal(arg, UMLDiagramEncoder.getPositionStartNonSpace(arg));
    }

    private static String trimEndingInternal(String arg, int from) {
        int j;
        for (j = arg.length() - 1; j >= from && UMLDiagramEncoder.isSpaceOrTabOrNull(arg.charAt(j)); --j) {
        }
        return from == 0 && j == arg.length() - 1 ? arg : arg.substring(from, j + 1);
    }

    private static boolean isSpaceOrTabOrNull(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000';
    }

    private static int getPositionStartNonSpace(String arg) {
        int i;
        for (i = 0; i < arg.length() && UMLDiagramEncoder.isSpaceOrTabOrNull(arg.charAt(i)); ++i) {
        }
        return i;
    }

    private static char encode6bit(byte b) {
        assert (b >= 0 && b < 64);
        if (b < 10) {
            return (char)(48 + b);
        }
        if ((b = (byte)(b - 10)) < 26) {
            return (char)(65 + b);
        }
        if ((b = (byte)(b - 26)) < 26) {
            return (char)(97 + b);
        }
        if ((b = (byte)(b - 26)) == 0) {
            return '-';
        }
        if (b == 1) {
            return '_';
        }
        assert (false);
        return '?';
    }

    static {
        for (byte b = 0; b < 64; b = (byte)(b + 1)) {
            UMLDiagramEncoder.encode6bit[b] = UMLDiagramEncoder.encode6bit(b);
            char c = encode6bit[b];
            byte by = b;
            UMLDiagramEncoder.decode6bit[c] = by;
        }
    }
}

