/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.providers.DiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;

public abstract class AbstractDiagramProvider
implements DiagramProvider {
    private Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected String getComponentType(Diagram diagram, String type) {
        return diagram.getVertexElement().getOrDefault(type, "rectangle");
    }

    protected String getEdgeConnector(Diagram diagram, String type) {
        return diagram.getEdgeConnectors().getOrDefault(type, "-->");
    }

    protected String generateGraphSchema(BasicGraph graph, Diagram diagram, List<Map<Object, String>> dependencyList) {
        String sourceId;
        StringBuilder relationBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        HashSet<String> entityList = new HashSet<String>();
        for (Map<Object, String> row : dependencyList) {
            sourceId = row.get("source");
            String destinationId = row.get("destination");
            entityList.add(sourceId);
            entityList.add(destinationId);
        }
        this.buildHeader(builder, diagram, entityList);
        for (Map<Object, String> row : dependencyList) {
            sourceId = row.get("source");
            JsonObject sourceVertex = graph.getVertex(sourceId);
            String sourceName = sourceVertex == null ? sourceId : sourceVertex.getString("name");
            String destinationId = row.get("destination");
            JsonObject destVertex = graph.getVertex(destinationId);
            String destinationName = destVertex == null ? destinationId : destVertex.getString("name");
            String edgeType = row.get("edge");
            builder.append("rectangle \"").append(sourceName).append("\" <<").append(sourceId).append(">> as ").append(this.escape(sourceId)).append("\n");
            builder.append("rectangle \"").append(destinationName).append("\" <<").append(destinationId).append(">> as ").append(this.escape(destinationId)).append("\n");
            relationBuilder.append(this.escape(sourceId)).append(" ").append(this.getEdgeConnector(diagram, edgeType)).append(" ").append(this.escape(destinationId)).append("\n");
        }
        builder.append((CharSequence)relationBuilder);
        builder.append("@enduml\n");
        return this.removeDublicatesLine(builder);
    }

    protected String removeDublicatesLine(StringBuilder builder) {
        String result = builder.toString();
        result = Arrays.asList(result.split("\n")).stream().distinct().collect(Collectors.joining("\n"));
        return result;
    }

    protected void buildHeader(StringBuilder builder, Diagram diagram, Set<String> entityList) {
        builder.append("@startuml\n\n");
        builder.append("scale 0.8\n");
        builder.append("left to right direction\n");
        builder.append("skinparam defaultTextAlignment center\n\n");
        if (diagram.getDefaultDomainLevelEntity() != null) {
            builder.append("skinparam rectangleBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.component", "Yellow")).append("\n");
            builder.append("skinparam artifactBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.component", "Yellow")).append("\n");
            builder.append("skinparam collectionsBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.component", "Yellow")).append("\n");
        }
        for (String entity : entityList) {
            if (diagram.getDefaultDomainLevelEntity() != null && diagram.getDefaultDomainLevelEntity().equals(entity)) {
                builder.append("skinparam rectangleBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.domain", "Gold")).append("\n");
                builder.append("skinparam artifactBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.domain", "Gold")).append("\n");
                builder.append("skinparam collectionsBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.domain", "Gold")).append("\n");
                continue;
            }
            builder.append("skinparam rectangleBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.c." + entity, "AntiqueWhite")).append("\n");
            builder.append("skinparam artifactBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.c." + entity, "AntiqueWhite")).append("\n");
            builder.append("skinparam collectionsBackgroundColor<<").append(entity).append(">> ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.c." + entity, "AntiqueWhite")).append("\n");
        }
        builder.append("skinparam databaseBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.database", "DeepSkyBlue")).append("\n");
        builder.append("skinparam queueBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.queue", "GreenYellow")).append("\n");
        builder.append("skinparam storageBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.caching", "Orchid")).append("\n");
    }

    protected String escape(String str) {
        return str.replaceAll("/|\\s|-|&|\\.|:", "_");
    }

    protected List<JsonObject> fetchVertex(BasicGraph graph, JsonObject vertex) {
        String vertexType = vertex.getString("type");
        if ("cip-element".equals(vertexType)) {
            return this.cipElementQuery(graph, vertex);
        }
        if ("cip-chain".equals(vertexType)) {
            return this.cipChainQuery(graph, vertex);
        }
        return Collections.singletonList(vertex);
    }

    protected List<JsonObject> cipElementQuery(BasicGraph graph, JsonObject vertex) {
        return graph.traversal().V(vertex.getString("id")).in(new String[0]).inE("defines", "implements").outV().dedup().toList();
    }

    protected List<JsonObject> cipChainQuery(BasicGraph graph, JsonObject vertex) {
        return graph.traversal().V(vertex.getString("id")).outE("includes").inV().has("type", "cip-element").out(new String[0]).dedup().toList();
    }

    protected List<Map<String, String>> getOptimizedSourceTarget(BasicGraph subgraph, BasicGraph graph, String edgeId) {
        ArrayList<Map<String, String>> sourceTargetList = new ArrayList<Map<String, String>>();
        String source = subgraph.getEdgeSource(edgeId).getString("id");
        String target = subgraph.getEdgeTarget(edgeId).getString("id");
        String sourceType = subgraph.getEdgeSource(edgeId).getString("type");
        String targetType = subgraph.getEdgeTarget(edgeId).getString("type");
        if ("cip-element".equals(sourceType)) {
            for (JsonObject cipElement : this.cipElementQuery(graph, subgraph.getEdgeSource(edgeId))) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("source", cipElement.getString("id"));
                result.put("target", target);
                sourceTargetList.add(result);
            }
        } else if ("cip-chain".equals(targetType)) {
            for (JsonObject serviceVertices : this.cipChainQuery(graph, subgraph.getEdgeTarget(edgeId))) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("source", source);
                result.put("target", serviceVertices.getString("id"));
                sourceTargetList.add(result);
            }
        } else {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("source", source);
            result.put("target", target);
            sourceTargetList.add(result);
        }
        return sourceTargetList;
    }
}

