/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import java.util.Properties;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.graph.BasicGraph;

public interface DiagramProvider {
    public static final String SKINPARAM_BACKGROUND_COLOR_DEFAULT_DOMAIN = "diagram.skinparam.backgroundColor.default.domain";
    public static final String SKINPARAM_BACKGROUND_COLOR_DEFAULT_COMPONENT = "diagram.skinparam.backgroundColor.default.component";
    public static final String SKINPARAM_BACKGROUND_COLOR = "diagram.skinparam.backgroundColor";
    public static final String SKINPARAM_BACKGROUND_COLOR_C = "diagram.skinparam.backgroundColor.c.";
    public static final String SKINPARAM_BACKGROUND_COLOR_DATABASE = "diagram.skinparam.backgroundColor.database";
    public static final String SKINPARAM_BACKGROUND_COLOR_QUEUE = "diagram.skinparam.backgroundColor.queue";
    public static final String SKINPARAM_BACKGROUND_COLOR_INDEXATION = "diagram.skinparam.backgroundColor.indexation";
    public static final String SKINPARAM_BACKGROUND_COLOR_CACHING = "diagram.skinparam.backgroundColor.caching";

    public void setProperties(Properties var1);

    public Properties getProperties();

    public String getType();

    default public String generate(DiagramService diagramService, BasicGraph graph, Diagram diagram) {
        return null;
    }

    default public String wrap(String value) {
        return value.replaceAll("-|,|\\.|\\s", "_");
    }

    default public String header(BasicGraph graph) {
        StringBuilder result = new StringBuilder();
        result.append("@startuml\n\nscale 0.8\nleft to right direction\nskinparam defaultTextAlignment center\n\n");
        result.append(this.skinparam(graph));
        return result.toString();
    }

    default public String skinparam(BasicGraph graph) {
        StringBuilder result = new StringBuilder();
        result.append("skinparam database {\n  backgroundColor ");
        result.append(this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_DATABASE, "GreenYellow"));
        result.append("\n}\n");
        result.append("skinparam queue {\n  backgroundColor ");
        result.append(this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_QUEUE, "GreenYellow"));
        result.append("\n}\n");
        result.append(this.skinparamDomains(graph));
        result.append("}\n");
        return result.toString();
    }

    default public String skinparamDomains(BasicGraph graph) {
        StringBuilder result = new StringBuilder();
        result.append("skinparam rectangle {\n").append("  backgroundColor<<database>> ").append(this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_DATABASE, "MistyRose")).append("\n").append("  backgroundColor<<indexation>> ").append(this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_INDEXATION, "MistyRose")).append("\n").append("  backgroundColor<<caching>> ").append(this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_CACHING, "MistyRose")).append("\n");
        for (JsonObject d : graph.traversal().V(new String[0]).hasType("domain").toList()) {
            String backgroundColor = this.getProperties().getProperty(SKINPARAM_BACKGROUND_COLOR_C + d.getString("id"), "Gainsboro");
            result.append("  backgroundColor<<" + d.getString("id") + ">> " + backgroundColor + "\n");
        }
        return result.toString();
    }

    default public String footer(BasicGraph graph) {
        return "\n@enduml\n";
    }

    default public String relation(String sourceId, String destinationId, String edgeType, String edgeName, boolean overrideType) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.wrap(sourceId));
        if ("GQL".equals(destinationId)) {
            tmp.append(" #-[#blue]- ");
        } else {
            if ("GQL".equals(sourceId)) {
                return null;
            }
            if (sourceId.equals(destinationId)) {
                return null;
            }
            if ("optional".equals(edgeType)) {
                if (overrideType) {
                    tmp.append(" --> ");
                } else {
                    tmp.append(" .[#gray].> ");
                }
            } else {
                tmp.append(" --> ");
            }
        }
        tmp.append(this.wrap(destinationId));
        if (edgeName != null) {
            tmp.append(" : ").append(edgeName.replaceAll("$\\{spring.application.cloud_namespace}", ""));
        }
        return tmp.toString();
    }

    default public String relation(String sourceId, String destinationId, String edgeType, boolean overrideType) {
        return this.relation(sourceId, destinationId, edgeType, null, overrideType);
    }

    default public String component(String mainDomain, JsonObject component) {
        String componentType = component.getString("type");
        String type = "rectangle";
        if ("caching".equals(componentType) || "database".equals(componentType) || "indexation".equals(componentType)) {
            type = "database";
        }
        if ("mq".equals(componentType)) {
            type = "queue";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(type).append(" \"").append(component.getString("name")).append("\"");
        String domain = null;
        if (component.getJsonObject("details") != null) {
            domain = component.getJsonObject("details").getString("domain");
        }
        if (domain == null && "domain".equals(component.getString("type"))) {
            domain = component.getString("id");
        }
        if (mainDomain == null && domain != null || domain != null && mainDomain != null && !mainDomain.equals(domain)) {
            builder.append(" <<").append(domain.toUpperCase()).append(">> ");
        } else if ("caching".equals(componentType) || "database".equals(componentType) || "indexation".equals(componentType)) {
            builder.append(" <<").append(componentType).append(">>");
        }
        builder.append(" as ").append(this.wrap(component.getString("id")));
        return builder.toString();
    }
}

