/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.providers.AbstractDiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;

public class MicroserviceDiagramProvider
extends AbstractDiagramProvider {
    @Override
    public String getType() {
        return "microservice";
    }

    @Override
    public String generate(DiagramService diagramService, BasicGraph graph, Diagram diagram) {
        BasicGraph subgraph;
        String department = diagram.getDepartment();
        String[] componentIds = diagram.getComponentIds() == null ? new String[]{} : diagram.getComponentIds().toArray(new String[0]);
        String[] excludeDomains = diagram.getExcludeDomains() == null ? new String[]{} : diagram.getExcludeDomains();
        GraphTraversal<JsonObject, JsonObject> traversal = graph.traversal().V(new String[0]);
        if (excludeDomains.length != 0) {
            traversal.hasType("domain").hasNotId(excludeDomains);
        }
        if (department != null) {
            traversal.hasType("domain").has("department", department);
        }
        traversal.out(new String[0]);
        if (componentIds.length != 0) {
            traversal.hasId(componentIds);
        }
        if ((subgraph = (BasicGraph)traversal.union(__.inE(diagram.getSupportedEdges()).not(__.outV().hasType("domain")).not(__.outV().has("/details/domain", P.within(excludeDomains))).subgraph("G"), __.outE(diagram.getSupportedEdges()).as("outE", new String[0]).not(__.inV().has("/details/domain", P.within(excludeDomains))).subgraph("G")).cap("G").next()) == null) {
            return null;
        }
        String result = this.generateDomainGraphSchema(graph, diagram, subgraph);
        return result;
    }

    protected String generateDomainGraphSchema(BasicGraph graph, Diagram diagram, BasicGraph subgraph) {
        String id;
        List<JsonObject> fetchedVertices;
        if (subgraph == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> entityList = new HashSet<String>();
        for (JsonObject vertex : subgraph.vertexList()) {
            fetchedVertices = this.fetchVertex(graph, vertex);
            for (JsonObject fetchedVertex : fetchedVertices) {
                if (fetchedVertex == null) continue;
                id = fetchedVertex.getString("id");
                String domain = (String)JsonPointer.from((String)"/details/domain").queryJson((Object)fetchedVertex);
                domain = domain == null ? fetchedVertex.getString("type") : domain;
                entityList.add(id);
                entityList.add(domain);
            }
        }
        this.buildHeader(builder, diagram, entityList);
        for (JsonObject vertex : subgraph.vertexList()) {
            fetchedVertices = this.fetchVertex(graph, vertex);
            for (JsonObject fetchedVertex : fetchedVertices) {
                if (fetchedVertex == null) continue;
                id = fetchedVertex.getString("id");
                String type = fetchedVertex.getString("type");
                String name = fetchedVertex.getString("name");
                String domain = (String)JsonPointer.from((String)"/details/domain").queryJson((Object)fetchedVertex);
                domain = domain == null ? fetchedVertex.getString("type") : domain;
                builder.append(this.getComponentType(diagram, type));
                builder.append(" \"").append(name).append("\" ");
                if (diagram.getDefaultComponent() == null && domain != null && !domain.equals(diagram.getDefaultDomainLevelEntity()) || diagram.getDefaultComponent() != null && diagram.getDefaultDomainLevelEntity() != null && !id.equals(diagram.getDefaultComponent())) {
                    builder.append("<<").append(domain).append(">> ");
                }
                builder.append(" as ").append(this.escape(id)).append("\n");
            }
        }
        builder.append("\n");
        for (JsonObject edge : subgraph.edgeList()) {
            String edgeId = edge.getString("id");
            String edgeType = edge.getString("type");
            List<Map<String, String>> sourceTargetPairs = this.getOptimizedSourceTarget(subgraph, graph, edgeId);
            for (Map<String, String> pair : sourceTargetPairs) {
                String source = pair.get("source");
                String target = pair.get("target");
                if (source == null || target == null) continue;
                builder.append(this.escape(source)).append(" ").append(this.getEdgeConnector(diagram, edgeType)).append(" ").append(this.escape(target)).append("\n");
            }
        }
        builder.append("\n");
        builder.append("@enduml\n");
        String result = this.removeDublicatesLine(builder);
        return result;
    }
}

