/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.git;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.IToolSubmoduleAddCommand;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAdapterImpl
implements GitAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(GitAdapterImpl.class);
    private GraphReport report;
    private Vertx vertx;
    private CredentialsProvider credentialsProvider;
    private JsonObject config;
    private WorkerExecutor executor;

    protected GitAdapterImpl(Vertx vertx, GraphReport report, JsonObject config) {
        this.report = report;
        this.vertx = vertx;
        String password = config.getString("password");
        String login = config.getString("login");
        this.credentialsProvider = new UsernamePasswordCredentialsProvider(login, password);
        this.config = config;
    }

    @Override
    public WorkerExecutor getWorkerExecutor() {
        if (this.executor == null) {
            Integer coresCount = CpuCoreSensor.availableProcessors();
            this.executor = this.vertx.createSharedWorkerExecutor("repository-worker-pool", coresCount.intValue(), 15L, TimeUnit.MINUTES);
        }
        return this.executor;
    }

    @Override
    public void setWorkerExecutor(WorkerExecutor executor) {
        this.executor = executor;
    }

    private String getFromConfig(String jsonPointer, JsonObject config) {
        String configValue = ConfigUtils.getConfigValue(jsonPointer, config);
        if (configValue == null) {
            this.report.internalError("Configuration entry is missing for " + jsonPointer + " property");
        }
        return configValue;
    }

    @Override
    public void gitAddHandler(Git repo, String filePattern, Promise promise) {
        LOG.info("Attempting to perform git add {} in {}", (Object)filePattern, (Object)repo.getRepository().getDirectory());
        try {
            repo.add().addFilepattern(filePattern).call();
        }
        catch (GitAPIException e) {
            promise.fail("Failed to add " + filePattern + " (" + e.getMessage() + ")");
            return;
        }
        promise.complete();
    }

    @Override
    public Future<Void> gitAdd(Git repo, String filePattern) {
        return this.getWorkerExecutor().executeBlocking(p -> this.gitAddHandler(repo, filePattern, (Promise)p));
    }

    @Override
    public void gitCommitHandler(Git repo, String message, Promise promise) {
        LOG.info("Attempting to perform git commit in {}", (Object)repo.getRepository().getDirectory());
        try {
            RevCommit commit = repo.commit().setMessage(message).call();
            LOG.info("Commit successful: " + commit.getFullMessage());
        }
        catch (GitAPIException e) {
            promise.fail("Failed to commit (" + e.getMessage() + ")");
            return;
        }
        promise.complete();
    }

    @Override
    public Future<Void> gitCommit(Git repo, String message) {
        return this.getWorkerExecutor().executeBlocking(p -> this.gitCommitHandler(repo, message, (Promise)p));
    }

    @Override
    public Future<Object> gitStatusCheck(Git repo, Predicate<Status> statusPredicate) {
        LOG.info("Checking the status of repository {}", (Object)repo.getRepository().getDirectory());
        return this.getWorkerExecutor().executeBlocking(promise -> {
            try {
                Status status = repo.status().call();
                promise.complete((Object)statusPredicate.test(status));
            }
            catch (GitAPIException e) {
                promise.fail("Failed to check the status (" + e.getMessage() + ")");
            }
        });
    }

    @Override
    public Future<Status> gitStatus(Git repo) {
        Future statusFuture = this.getWorkerExecutor().executeBlocking(p -> {
            try {
                p.complete((Object)repo.status().call());
            }
            catch (GitAPIException e) {
                p.fail((Throwable)e);
            }
        });
        return statusFuture;
    }

    @Override
    public Future<Void> gitRm(Git repo, Collection<String> files) {
        LOG.info("Attempting to remove files {} from repository {}", files, (Object)repo.getRepository().getDirectory());
        Future rmFuture = this.getWorkerExecutor().executeBlocking(p -> {
            try {
                RmCommand rmCommand = repo.rm();
                files.stream().forEach(f -> rmCommand.addFilepattern(f));
                rmCommand.call();
                LOG.info("Removal of files {} from repository {} finished", (Object)files, (Object)repo.getRepository().getDirectory());
                p.complete();
            }
            catch (GitAPIException e) {
                p.fail((Throwable)e);
            }
        });
        return rmFuture;
    }

    @Override
    public void submoduleUpdateHandler(Git repository, Promise promise) {
        LOG.info("Performing submodule update. This may take hours depending on your Internet connection.");
        try {
            ((SubmoduleUpdateCommand)repository.submoduleUpdate().setCredentialsProvider(this.credentialsProvider)).call();
        }
        catch (GitAPIException e) {
            promise.fail("Unable to perform submodule update: " + ExceptionUtils.getStackTrace((Throwable)e));
            return;
        }
        LOG.info("Submodule update completed");
        promise.complete();
    }

    @Override
    public Future<Void> submoduleUpdate(Git repository) {
        return this.getWorkerExecutor().executeBlocking(p -> this.submoduleUpdateHandler(repository, (Promise)p));
    }

    @Override
    public List<Future> bulkSubmoduleAdd(Git superRepo, List<Map<String, JsonObject>> components) {
        Map submoduleStatus;
        ArrayList<Future> futures = new ArrayList<Future>();
        try {
            submoduleStatus = superRepo.submoduleStatus().call();
        }
        catch (GitAPIException e) {
            this.report.exceptionThrown(new JsonObject(), (Exception)((Object)e));
            return futures;
        }
        for (Map<String, JsonObject> componentJson : components) {
            JsonObject component = componentJson.get("component");
            String cloneFolder = component.getString("directoryPath");
            Path submodulePath = Path.of(cloneFolder, new String[0]);
            String componentId = component.getString("id");
            JsonObject domain = componentJson.get("domain");
            if (submoduleStatus.keySet().stream().anyMatch(modulePath -> submodulePath.endsWith((String)modulePath))) {
                LOG.info("Component submodule of {} in {} already exist", (Object)componentId, (Object)cloneFolder);
                continue;
            }
            Future future = this.getWorkerExecutor().executeBlocking(p -> this.submoduleAddHandler(superRepo, component, domain, (Promise)p), true);
            futures.add(future);
        }
        return futures;
    }

    @Override
    public void submoduleAddHandler(Git superRepo, JsonObject component, JsonObject domain, Promise promise) {
        if (superRepo == null) {
            promise.fail("Superrepo cannot be null");
            return;
        }
        String repositoryLink = component.getString("repository");
        String domainId = domain.getString("id");
        String componentId = component.getString("id");
        LOG.info("Adding the repository of component {}@{} with source {}", new Object[]{componentId, domainId, repositoryLink});
        if (repositoryLink == null) {
            this.report.mandatoryValueMissed(component, "repository");
            promise.fail("Component " + component.getString("id") + " doesn't contain repository link");
            return;
        }
        String cloneFolder = component.getString("directoryPath");
        Path submodulePath = Path.of(cloneFolder, new String[0]);
        Repository repository = null;
        try {
            String submoduleDir = superRepo.getRepository().getDirectory().toPath().getParent().toAbsolutePath().relativize(submodulePath.toAbsolutePath()).toString().replaceAll("\\\\", "/");
            IToolSubmoduleAddCommand submoduleAddCommand = new IToolSubmoduleAddCommand(superRepo.getRepository());
            try {
                repository = ((SubmoduleAddCommand)submoduleAddCommand.setCredentialsProvider(this.credentialsProvider)).setURI(repositoryLink).setPath(submoduleDir).call();
            }
            catch (TransportException te) {
                LOG.warn("Error while trying to add submodule {}: {}. Trying again once", (Object)repositoryLink, (Object)te.getMessage());
                repository = ((SubmoduleAddCommand)submoduleAddCommand.setCredentialsProvider(this.credentialsProvider)).setURI(repositoryLink).setPath(submoduleDir).call();
            }
        }
        catch (GitAPIException | JGitInternalException e) {
            this.report.exceptionThrown(new JsonObject(), (Exception)e);
            promise.fail(e);
            return;
        }
        repository.close();
        LOG.info("Component repository of {} added to {}", (Object)componentId, (Object)cloneFolder);
        promise.complete();
    }

    @Override
    public Future<Void> submoduleAdd(Git superRepo, JsonObject component, JsonObject domain) {
        return this.getWorkerExecutor().executeBlocking(p -> this.submoduleAddHandler(superRepo, component, domain, (Promise)p));
    }

    @Override
    public void initSuperRepoHandler(String directoryPath, Promise promise) {
        LOG.info("Initializing the new repository {}", (Object)directoryPath);
        if (StringUtils.isEmpty((CharSequence)directoryPath)) {
            promise.fail("Repository directory path is empty");
            return;
        }
        File superRepoPath = new File(directoryPath);
        File gitFolder = new File(superRepoPath.getPath() + File.separator + ".git");
        if (gitFolder.exists()) {
            LOG.warn("Repository already exist");
            try {
                promise.complete((Object)Git.open((File)gitFolder));
                return;
            }
            catch (IOException e) {
                this.report.exceptionThrown(new JsonObject(), e);
            }
        }
        superRepoPath.mkdirs();
        Git superRepository = null;
        try {
            superRepository = Git.init().setDirectory(superRepoPath).call();
        }
        catch (GitAPIException e) {
            this.report.exceptionThrown(new JsonObject(), (Exception)((Object)e));
            promise.fail((Throwable)e);
        }
        LOG.info("Repository {} cloned successfully", (Object)superRepoPath.getPath());
        promise.complete((Object)superRepository);
    }

    @Override
    public void openRepositoryHandler(Promise p) {
        String superRepositoryDir = this.getFromConfig("/git/superRepositoryDir", this.config);
        LOG.info("Attempting to open repository {}", (Object)superRepositoryDir);
        if (StringUtils.isEmpty((CharSequence)superRepositoryDir)) {
            p.fail("Repository directory path is empty");
            return;
        }
        File superRepoPath = new File(superRepositoryDir);
        File gitFolder = new File(superRepoPath.getPath() + File.separator + ".git");
        if (gitFolder.exists()) {
            try {
                p.complete((Object)Git.open((File)gitFolder));
            }
            catch (IOException e) {
                p.fail((Throwable)e);
            }
        } else {
            p.fail("Repository " + superRepositoryDir + " does not exist");
        }
    }

    @Override
    public Future<Git> openSuperrepository() {
        return this.getWorkerExecutor().executeBlocking(this::openRepositoryHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void submodulesCheckoutHandler(Git repository, String release, List<JsonObject> components, Promise promise) {
        LOG.info("Performing checkout of branches for release {} in all modules", (Object)release);
        if (repository == null) {
            promise.fail("Repository cannot be null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)release)) {
            promise.fail("Release name cannot be null or empty");
            return;
        }
        try (SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository.getRepository());){
            while (walk.next()) {
                block23: {
                    try {
                        Repository module = walk.getRepository();
                        try {
                            if (module == null) {
                                this.report.internalError("Module in superrepository " + String.valueOf(repository.getRepository().getDirectory()) + " is null");
                                continue;
                            }
                            List matchedComponents = components.stream().filter(o -> this.isComponentMatchingModule(module, (JsonObject)o)).collect(Collectors.toList());
                            if (matchedComponents.size() == 0) continue;
                            if (matchedComponents.size() > 1) {
                                this.report.internalError("Found more than one component for repository " + module.getDirectory().toString() + ": " + String.valueOf(matchedComponents));
                                continue;
                            }
                            String branch = (String)JsonPointer.from((String)"/details/releaseBranch").queryJson(matchedComponents.stream().findFirst().get());
                            this.checkout(Git.wrap((Repository)module), branch);
                            break block23;
                        }
                        finally {
                            if (module == null) continue;
                            module.close();
                        }
                    }
                    catch (GitAPIException e) {
                        this.report.internalError("Unable to checkout release " + release + ": " + ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    continue;
                }
                LOG.info("Checkout of release " + release + " in repository " + walk.getRepository().getWorkTree().toString() + " completed.");
            }
        }
        catch (IOException e) {
            this.report.internalError("Unable to perform checkout of " + release + ": " + e.getMessage());
            promise.fail((Throwable)e);
            return;
        }
        promise.complete();
    }

    private Boolean isComponentMatchingModule(Repository module, JsonObject component) {
        String moduleDir = this.getTrailingSubpath(module.getDirectory().toPath(), 2);
        String directoryPathDir = this.getTrailingSubpath(Path.of(component.getString("directoryPath"), new String[0]), 2);
        return directoryPathDir.equals(moduleDir);
    }

    private String getTrailingSubpath(Path directoryPath, int levelsToKeep) {
        int directoryPathLength = directoryPath.getNameCount();
        return directoryPath.subpath(directoryPathLength - levelsToKeep, directoryPathLength).toString();
    }

    @Override
    public Future<Void> submodulesCheckout(Git superrepo, String release, List<JsonObject> components) {
        return this.getWorkerExecutor().executeBlocking(p -> this.submodulesCheckoutHandler(superrepo, release, components, (Promise)p));
    }

    public void checkout(Git repository, String ref) throws GitAPIException {
        LOG.info("Checking out ref " + ref + " of repository " + String.valueOf(repository.getRepository().getDirectory()));
        List remotes = repository.remoteList().call();
        Object reference = ref;
        if (!remotes.isEmpty()) {
            String remote = ((RemoteConfig)remotes.get(0)).getName();
            reference = remote + "/" + ref;
            LOG.debug("Performing git fetch for repository {}", (Object)repository.getRepository().getDirectory());
            ((FetchCommand)repository.fetch().setCredentialsProvider(this.credentialsProvider)).call();
        }
        try {
            repository.checkout().setName((String)reference).setForceRefUpdate(true).setForced(true).call();
        }
        catch (RefNotFoundException e) {
            LOG.debug("Reference {} was not found, trying to find local ref {} in {}", new Object[]{reference, ref, repository.getRepository().getDirectory()});
            repository.checkout().setName(ref).setForceRefUpdate(true).setForced(true).call();
        }
    }

    public Future branchCheckout(Git repository, String branch) {
        return this.getWorkerExecutor().executeBlocking(p -> {
            try {
                this.checkout(repository, branch);
                p.complete();
            }
            catch (GitAPIException e) {
                p.fail((Throwable)e);
            }
        }).onFailure(e -> this.report.internalError("Failed to checkout branch " + branch + ": " + ExceptionUtils.getStackTrace((Throwable)e)));
    }

    @Override
    public void prepareSuperRepoHandler(Promise<Git> promise) {
        String superRepositoryDir = this.getFromConfig("/git/superRepositoryDir", this.config);
        String superRepositoryUri = this.getFromConfig("/git/superRepositoryUrl", this.config);
        if (StringUtils.isEmpty((CharSequence)superRepositoryDir)) {
            promise.fail("Repository directory path is empty");
            return;
        }
        LOG.info("Preparing repository {}", (Object)superRepositoryDir);
        File gitFolder = Path.of(superRepositoryDir, ".git").toFile();
        Git superRepository = null;
        if (gitFolder.exists()) {
            LOG.info("Repository already exist");
            try {
                superRepository = Git.open((File)gitFolder);
            }
            catch (IOException e) {
                LOG.error("Unable to open super repository {}", (Object)gitFolder);
                promise.fail((Throwable)e);
                return;
            }
        }
        try {
            superRepository = this.superRepositoryClone(superRepositoryUri, superRepositoryDir);
        }
        catch (GitAPIException e) {
            LOG.warn("Clone of the super repository failed: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
            try {
                superRepository = this.prepareLocalRepo(superRepositoryDir);
            }
            catch (GitAPIException e2) {
                LOG.error("Unable to init the new super repository {}", (Object)superRepositoryDir);
                promise.fail((Throwable)e2);
                return;
            }
        }
        promise.complete((Object)superRepository);
    }

    private Git prepareLocalRepo(String superRepositoryUri) throws GitAPIException {
        LOG.warn("Preparing empty repository in {}", (Object)superRepositoryUri);
        String main = ConfigUtils.getConfigValue("/git/defaultMainBranch", this.config);
        Git superRepository = Git.init().setDirectory(new File(superRepositoryUri)).setInitialBranch(main).call();
        superRepository.commit().setMessage("initial commit").setAllowEmpty(true).call();
        LOG.info("New repository creation in {} finished successfully", (Object)superRepositoryUri);
        return superRepository;
    }

    @Override
    public Future switchSuperRepoBranch(Git superRepository, String superRepositoryBranch) {
        return this.getWorkerExecutor().executeBlocking(promise -> {
            try {
                this.checkoutSuperRepoReleaseBranch(superRepository, superRepositoryBranch);
            }
            catch (GitAPIException e) {
                promise.fail((Throwable)e);
            }
            promise.complete();
        }).onFailure(e -> this.report.internalError("Could not checkout " + superRepositoryBranch + " branch of superrepository: " + ExceptionUtils.getStackTrace((Throwable)e)));
    }

    @Override
    public Future<Git> prepareSuperRepository() {
        return this.getWorkerExecutor().executeBlocking(this::prepareSuperRepoHandler);
    }

    private void checkoutSuperRepoReleaseBranch(Git superRepository, String superRepositoryBranch) throws GitAPIException {
        LOG.info("Attempting to checkout branch {} in super repository", (Object)superRepositoryBranch);
        try {
            this.checkout(superRepository, superRepositoryBranch);
        }
        catch (GitAPIException e) {
            String main = ConfigUtils.getConfigValue("/git/defaultMainBranch", this.config);
            Object branch = "origin/" + main;
            if (superRepository.remoteList().call().isEmpty()) {
                branch = main;
            }
            LOG.warn("Checkout of branch {} failed ({}), creating the new branch based on {}", new Object[]{superRepositoryBranch, e.getMessage(), branch});
            superRepository.branchCreate().setStartPoint((String)branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(superRepositoryBranch).setForce(true).call();
            superRepository.checkout().setName(superRepositoryBranch).call();
        }
        LOG.info("Performing submodule init for repository {}", (Object)superRepository.getRepository().getDirectory());
        superRepository.submoduleInit().call();
    }

    private Git superRepositoryClone(String uri, String directoryPath) throws GitAPIException {
        LOG.info("Cloning the repository {} to {}", (Object)uri, (Object)directoryPath);
        String main = ConfigUtils.getConfigValue("/git/defaultMainBranch", this.config);
        Git superRepo = ((CloneCommand)Git.cloneRepository().setCloneSubmodules(true).setURI(uri).setCredentialsProvider(this.credentialsProvider)).setDirectory(new File(directoryPath)).setBranch(main).call();
        LOG.info("Performing submodule init for repository {}", (Object)directoryPath);
        superRepo.submoduleInit().call();
        return superRepo;
    }
}

