/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.git;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.util.ShutdownHook;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class IToolCloneCommand
extends CloneCommand {
    private String uri;
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean cloneAllBranches;
    private boolean mirror;
    private boolean cloneSubmodules;
    private boolean noCheckout;
    private Collection<String> branchesToClone;
    private CloneCommand.Callback callback;
    private boolean directoryExistsInitially;
    private boolean gitDirExistsInitially;
    private FETCH_TYPE fetchType;
    private TagOpt tagOption;
    private Integer depth;
    private Instant shallowSince;
    private List<String> shallowExcludes = new ArrayList<String>();
    private ShutdownHook.Listener shutdownListener = this::cleanup;
    private Boolean force = Boolean.FALSE;

    @Nullable
    File getDirectory() {
        return this.directory;
    }

    public Git call() throws GitAPIException, InvalidRemoteException, TransportException {
        URIish u = null;
        try {
            u = new URIish(this.uri);
            this.initDirectories(u);
            IToolCloneCommand.validateDirs(this.directory, this.gitDir, this.bare);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidURL, this.uri), (Throwable)e);
        }
        if (!this.force.booleanValue()) {
            this.verifyDirectories();
        }
        this.setFetchType();
        Repository repository = this.init();
        FetchResult fetchResult = null;
        ShutdownHook.INSTANCE.register(this.shutdownListener);
        try {
            fetchResult = this.fetch(repository, u);
        }
        catch (IOException ioe) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new JGitInternalException(ioe.getMessage(), (Throwable)ioe);
        }
        catch (URISyntaxException e) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), (Throwable)e);
        }
        catch (RuntimeException | GitAPIException e) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw e;
        }
        finally {
            ShutdownHook.INSTANCE.unregister(this.shutdownListener);
        }
        try {
            this.checkout(repository, fetchResult);
        }
        catch (IOException ioe) {
            repository.close();
            throw new JGitInternalException(ioe.getMessage(), (Throwable)ioe);
        }
        catch (RuntimeException | GitAPIException e) {
            repository.close();
            throw e;
        }
        return new Git(repository);
    }

    private void initDirectories(URIish u) {
        if (this.directory == null && this.gitDir == null) {
            this.directory = new File(u.getHumanishName() + (this.bare ? ".git" : ""));
        }
        this.directoryExistsInitially = this.directory != null && this.directory.exists();
        this.gitDirExistsInitially = this.gitDir != null && this.gitDir.exists();
    }

    private void setFetchType() {
        if (this.mirror) {
            this.fetchType = FETCH_TYPE.MIRROR;
            this.setBare(true);
        } else {
            this.fetchType = this.cloneAllBranches ? FETCH_TYPE.ALL_BRANCHES : (this.branchesToClone != null && !this.branchesToClone.isEmpty() ? FETCH_TYPE.MULTIPLE_BRANCHES : FETCH_TYPE.ALL_BRANCHES);
        }
    }

    private static boolean isNonEmptyDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            return files != null && files.length != 0;
        }
        return false;
    }

    void verifyDirectories() {
        if (IToolCloneCommand.isNonEmptyDirectory(this.directory)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.directory.getName()));
        }
        if (IToolCloneCommand.isNonEmptyDirectory(this.gitDir)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.gitDir.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository init() throws GitAPIException {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.fs != null) {
            command.setFs(this.fs);
        }
        if (this.directory != null) {
            command.setDirectory(this.directory);
        }
        if (this.gitDir != null) {
            command.setGitDir(this.gitDir);
        }
        Git git = command.call();
        if (!this.bare) {
            File workTree = git.getRepository().getWorkTree();
            File dotFile = new File(workTree, ".git");
            if (!git.getRepository().getDirectory().getParentFile().equals(workTree) && !dotFile.exists()) {
                LockFile dotGitLockFile = new LockFile(dotFile);
                try {
                    if (dotGitLockFile.lock()) {
                        dotGitLockFile.write(Constants.encode((String)("gitdir: " + git.getRepository().getDirectory().getAbsolutePath())));
                        dotGitLockFile.commit();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    dotGitLockFile.unlock();
                }
            }
        }
        return git.getRepository();
    }

    private FetchResult fetch(Repository clonedRepo, URIish u) throws URISyntaxException, TransportException, IOException, GitAPIException {
        RemoteConfig config = new RemoteConfig((Config)clonedRepo.getConfig(), this.remote);
        config.addURI(u);
        boolean fetchAll = this.fetchType == FETCH_TYPE.ALL_BRANCHES || this.fetchType == FETCH_TYPE.MIRROR;
        config.setFetchRefSpecs(this.calculateRefSpecs(this.fetchType, config.getName()));
        config.setMirror(this.fetchType == FETCH_TYPE.MIRROR);
        if (this.tagOption != null) {
            config.setTagOpt(this.tagOption);
        }
        config.update((Config)clonedRepo.getConfig());
        clonedRepo.getConfig().save();
        FetchCommand command = Git.wrap((Repository)clonedRepo).fetch();
        command.setRemote(this.remote);
        command.setProgressMonitor(this.monitor);
        if (this.tagOption != null) {
            command.setTagOpt(this.tagOption);
        } else {
            command.setTagOpt(fetchAll ? TagOpt.FETCH_TAGS : TagOpt.AUTO_FOLLOW);
        }
        command.setInitialBranch(this.branch);
        if (this.depth != null) {
            command.setDepth(this.depth.intValue());
        }
        if (this.shallowSince != null) {
            command.setShallowSince(this.shallowSince);
        }
        for (String shallowExclude : this.shallowExcludes) {
            command.addShallowExclude(shallowExclude);
        }
        this.configure((TransportCommand)command);
        return command.call();
    }

    private List<RefSpec> calculateRefSpecs(FETCH_TYPE type, String remoteName) {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (type == FETCH_TYPE.MIRROR) {
            specs.add(new RefSpec().setForceUpdate(true).setSourceDestination("refs/*", "refs/*"));
        } else {
            RefSpec heads = new RefSpec();
            heads = heads.setForceUpdate(true);
            String dst = (String)(this.bare ? "refs/heads/" : "refs/remotes/" + remoteName + "/") + "*";
            heads = heads.setSourceDestination("refs/heads/*", dst);
            if (type == FETCH_TYPE.MULTIPLE_BRANCHES) {
                RefSpec tags = new RefSpec().setForceUpdate(true).setSourceDestination("refs/tags/*", "refs/tags/*");
                for (String selectedRef : this.branchesToClone) {
                    if (heads.matchSource(selectedRef)) {
                        specs.add(heads.expandFromSource(selectedRef));
                        continue;
                    }
                    if (!tags.matchSource(selectedRef)) continue;
                    specs.add(tags.expandFromSource(selectedRef));
                }
            } else {
                specs.add(heads);
            }
        }
        return specs;
    }

    private void checkout(Repository clonedRepo, FetchResult result) throws MissingObjectException, IncorrectObjectTypeException, IOException, GitAPIException {
        Ref foundBranch;
        Ref head = null;
        if (this.branch.equals("HEAD") && (foundBranch = this.findBranchToCheckout(result)) != null) {
            head = foundBranch;
        }
        if (head == null) {
            head = result.getAdvertisedRef(this.branch);
            if (head == null) {
                head = result.getAdvertisedRef("refs/heads/" + this.branch);
            }
            if (head == null) {
                head = result.getAdvertisedRef("refs/tags/" + this.branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return;
        }
        if (head.getName().startsWith("refs/heads/")) {
            RefUpdate newHead = clonedRepo.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            this.addMergeConfig(clonedRepo, head);
        }
        RevCommit commit = this.parseCommit(clonedRepo, head);
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = clonedRepo.updateRef("HEAD", detached);
        u.setNewObjectId((AnyObjectId)commit.getId());
        u.forceUpdate();
        if (!this.bare && !this.noCheckout) {
            DirCache dc = clonedRepo.lockDirCache();
            DirCacheCheckout co = new DirCacheCheckout(clonedRepo, dc, (ObjectId)commit.getTree());
            co.setProgressMonitor(this.monitor);
            co.checkout();
            if (this.cloneSubmodules) {
                this.cloneSubmodules(clonedRepo);
            }
        }
    }

    private void cloneSubmodules(Repository clonedRepo) throws IOException, GitAPIException {
        SubmoduleInitCommand init = new SubmoduleInitCommand(clonedRepo);
        Collection submodules = init.call();
        if (submodules.isEmpty()) {
            return;
        }
        if (this.callback != null) {
            this.callback.initializedSubmodules(submodules);
        }
        SubmoduleUpdateCommand update = new SubmoduleUpdateCommand(clonedRepo);
        this.configure((TransportCommand)update);
        update.setProgressMonitor(this.monitor);
        update.setCallback(this.callback);
        if (!update.call().isEmpty()) {
            SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)clonedRepo);
            while (walk.next()) {
                try (Repository subRepo = walk.getRepository();){
                    if (subRepo == null) continue;
                    this.cloneSubmodules(subRepo);
                }
            }
        }
    }

    private Ref findBranchToCheckout(FetchResult result) {
        ObjectId objectId;
        ObjectId headId;
        Ref idHEAD = result.getAdvertisedRef("HEAD");
        ObjectId objectId2 = headId = idHEAD != null ? idHEAD.getObjectId() : null;
        if (headId == null) {
            return null;
        }
        if (idHEAD != null && idHEAD.isSymbolic()) {
            return idHEAD.getTarget();
        }
        Ref master = result.getAdvertisedRef("refs/heads/master");
        ObjectId objectId3 = objectId = master != null ? master.getObjectId() : null;
        if (headId.equals((AnyObjectId)objectId)) {
            return master;
        }
        Ref foundBranch = null;
        for (Ref r : result.getAdvertisedRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/") || !headId.equals((AnyObjectId)r.getObjectId())) continue;
            foundBranch = r;
            break;
        }
        return foundBranch;
    }

    private void addMergeConfig(Repository clonedRepo, Ref head) throws IOException {
        String branchName = Repository.shortenRefName((String)head.getName());
        clonedRepo.getConfig().setString("branch", branchName, "remote", this.remote);
        clonedRepo.getConfig().setString("branch", branchName, "merge", head.getName());
        String autosetupRebase = clonedRepo.getConfig().getString("branch", null, "autosetuprebase");
        if ("always".equals(autosetupRebase) || "remote".equals(autosetupRebase)) {
            clonedRepo.getConfig().setEnum("branch", branchName, "rebase", (Enum)BranchConfig.BranchRebaseMode.REBASE);
        }
        clonedRepo.getConfig().save();
    }

    private RevCommit parseCommit(Repository clonedRepo, Ref ref) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        try (RevWalk rw = new RevWalk(clonedRepo);){
            commit = rw.parseCommit((AnyObjectId)ref.getObjectId());
        }
        return commit;
    }

    public IToolCloneCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public IToolCloneCommand setDirectory(File directory) {
        IToolCloneCommand.validateDirs(directory, this.gitDir, this.bare);
        this.directory = directory;
        return this;
    }

    public IToolCloneCommand setGitDir(File gitDir) {
        IToolCloneCommand.validateDirs(this.directory, gitDir, this.bare);
        this.gitDir = gitDir;
        return this;
    }

    public IToolCloneCommand setBare(boolean bare) throws IllegalStateException {
        IToolCloneCommand.validateDirs(this.directory, this.gitDir, bare);
        this.bare = bare;
        return this;
    }

    public IToolCloneCommand setFs(FS fs) {
        this.fs = fs;
        return this;
    }

    public IToolCloneCommand setRemote(String remote) {
        if (remote == null) {
            remote = "origin";
        }
        this.remote = remote;
        return this;
    }

    public IToolCloneCommand setBranch(String branch) {
        if (branch == null) {
            branch = "HEAD";
        }
        this.branch = branch;
        return this;
    }

    public IToolCloneCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public IToolCloneCommand setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
        return this;
    }

    public IToolCloneCommand setMirror(boolean mirror) {
        this.mirror = mirror;
        return this;
    }

    public IToolCloneCommand setCloneSubmodules(boolean cloneSubmodules) {
        this.cloneSubmodules = cloneSubmodules;
        return this;
    }

    public IToolCloneCommand setBranchesToClone(Collection<String> branchesToClone) {
        this.branchesToClone = branchesToClone;
        return this;
    }

    public IToolCloneCommand setTagOption(TagOpt tagOption) {
        this.tagOption = tagOption;
        return this;
    }

    public IToolCloneCommand setNoTags() {
        return this.setTagOption(TagOpt.NO_TAGS);
    }

    public IToolCloneCommand setNoCheckout(boolean noCheckout) {
        this.noCheckout = noCheckout;
        return this;
    }

    public IToolCloneCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public IToolCloneCommand setDepth(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException(JGitText.get().depthMustBeAt1);
        }
        this.depth = depth;
        return this;
    }

    public IToolCloneCommand setShallowSince(@NonNull OffsetDateTime shallowSince) {
        this.shallowSince = shallowSince.toInstant();
        return this;
    }

    public IToolCloneCommand setShallowSince(@NonNull Instant shallowSince) {
        this.shallowSince = shallowSince;
        return this;
    }

    public IToolCloneCommand addShallowExclude(@NonNull String shallowExclude) {
        this.shallowExcludes.add(shallowExclude);
        return this;
    }

    public IToolCloneCommand addShallowExclude(@NonNull ObjectId shallowExclude) {
        this.shallowExcludes.add(shallowExclude.name());
        return this;
    }

    private static void validateDirs(File directory, File gitDir, boolean bare) throws IllegalStateException {
        if (directory != null) {
            if (directory.exists() && !directory.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedDirIsNoDirectory, directory));
            }
            if (gitDir != null && gitDir.exists() && !gitDir.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedGitDirIsNoDirectory, gitDir));
            }
            if (bare) {
                if (gitDir != null && !gitDir.equals(directory)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, gitDir, directory));
                }
            } else if (gitDir != null && gitDir.equals(directory)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, gitDir, directory));
            }
        }
    }

    private void cleanup() {
        try {
            if (this.directory != null) {
                if (!this.directoryExistsInitially) {
                    FileUtils.delete((File)this.directory, (int)13);
                } else {
                    this.deleteChildren(this.directory);
                }
            }
            if (this.gitDir != null) {
                if (!this.gitDirExistsInitially) {
                    FileUtils.delete((File)this.gitDir, (int)13);
                } else {
                    this.deleteChildren(this.gitDir);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteChildren(File file) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File child : files) {
            FileUtils.delete((File)child, (int)13);
        }
    }

    void setForce(Boolean force) {
        this.force = force;
    }

    private static enum FETCH_TYPE {
        MULTIPLE_BRANCHES,
        ALL_BRANCHES,
        MIRROR;

    }
}

