/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.git;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.qubership.itool.modules.git.IToolCloneCommand;

public class IToolSubmoduleAddCommand
extends SubmoduleAddCommand {
    private String name;
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public IToolSubmoduleAddCommand(Repository repo) {
        super(repo);
    }

    public IToolSubmoduleAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public IToolSubmoduleAddCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public IToolSubmoduleAddCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public IToolSubmoduleAddCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected boolean submoduleExists() throws IOException {
        PathFilter filter = PathFilter.create((String)this.path);
        try (SubmoduleWalk w = SubmoduleWalk.forIndex((Repository)this.repo);){
            boolean bl = w.setFilter((TreeFilter)filter).next();
            return bl;
        }
    }

    public Repository call() throws GitAPIException {
        String resolvedUri;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = this.path;
        }
        try {
            SubmoduleValidator.assertValidSubmoduleName((String)this.name);
            SubmoduleValidator.assertValidSubmodulePath((String)this.path);
            SubmoduleValidator.assertValidSubmoduleUri((String)this.uri);
        }
        catch (SubmoduleValidator.SubmoduleValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        try {
            resolvedUri = SubmoduleWalk.getSubmoduleRemoteUrl((Repository)this.repo, (String)this.uri);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        File moduleDirectory = SubmoduleWalk.getSubmoduleDirectory((Repository)this.repo, (String)this.path);
        IToolCloneCommand clone = new IToolCloneCommand();
        this.configure((TransportCommand)clone);
        clone.setForce(true);
        clone.setDirectory(moduleDirectory);
        clone.setGitDir(new File(new File(this.repo.getCommonDirectory(), "modules"), this.path));
        clone.setURI(resolvedUri);
        if (this.monitor != null) {
            clone.setProgressMonitor(this.monitor);
        }
        Repository subRepo = null;
        try (Git git = clone.call();){
            subRepo = git.getRepository();
            subRepo.incrementOpen();
        }
        StoredConfig config = this.repo.getConfig();
        config.setString("submodule", this.name, "url", resolvedUri);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        FileBasedConfig modulesConfig = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            modulesConfig.load();
            modulesConfig.setString("submodule", this.name, "path", this.path);
            modulesConfig.setString("submodule", this.name, "url", this.uri);
            modulesConfig.save();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        AddCommand add = new AddCommand(this.repo);
        add.addFilepattern(".gitmodules");
        add.addFilepattern(this.path);
        try {
            add.call();
        }
        catch (NoFilepatternException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
        return subRepo;
    }
}

